﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
    @file
    @brief      sdmmc モジュール用の、ログを出力する API の宣言です。
*/

#include <nn/nn_Common.h>
#include <nn/diag/detail/diag_DetailStructuredSdkLog.h>

#define NN_DETAIL_SDMMC_TRACE(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(sdmmc, Trace, 0, ##__VA_ARGS__)
#define NN_DETAIL_SDMMC_TRACE_V1(...)               NN_DETAIL_STRUCTURED_SDK_LOG(sdmmc, Trace, 1, ##__VA_ARGS__)
#define NN_DETAIL_SDMMC_TRACE_V2(...)               NN_DETAIL_STRUCTURED_SDK_LOG(sdmmc, Trace, 2, ##__VA_ARGS__)
#define NN_DETAIL_SDMMC_TRACE_V3(...)               NN_DETAIL_STRUCTURED_SDK_LOG(sdmmc, Trace, 3, ##__VA_ARGS__)

#define NN_DETAIL_SDMMC_INFO(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(sdmmc, Info, 0, ##__VA_ARGS__)
#define NN_DETAIL_SDMMC_INFO_V1(...)                NN_DETAIL_STRUCTURED_SDK_LOG(sdmmc, Info, 1, ##__VA_ARGS__)
#define NN_DETAIL_SDMMC_INFO_V2(...)                NN_DETAIL_STRUCTURED_SDK_LOG(sdmmc, Info, 2, ##__VA_ARGS__)
#define NN_DETAIL_SDMMC_INFO_V3(...)                NN_DETAIL_STRUCTURED_SDK_LOG(sdmmc, Info, 3, ##__VA_ARGS__)

#define NN_DETAIL_SDMMC_WARN(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(sdmmc, Warn, 0, ##__VA_ARGS__)
#define NN_DETAIL_SDMMC_WARN_V1(...)                NN_DETAIL_STRUCTURED_SDK_LOG(sdmmc, Warn, 1, ##__VA_ARGS__)
#define NN_DETAIL_SDMMC_WARN_V2(...)                NN_DETAIL_STRUCTURED_SDK_LOG(sdmmc, Warn, 2, ##__VA_ARGS__)
#define NN_DETAIL_SDMMC_WARN_V3(...)                NN_DETAIL_STRUCTURED_SDK_LOG(sdmmc, Warn, 3, ##__VA_ARGS__)

#define NN_DETAIL_SDMMC_ERROR(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(sdmmc, Error, 0, ##__VA_ARGS__)
#define NN_DETAIL_SDMMC_ERROR_V1(...)               NN_DETAIL_STRUCTURED_SDK_LOG(sdmmc, Error, 1, ##__VA_ARGS__)
#define NN_DETAIL_SDMMC_ERROR_V2(...)               NN_DETAIL_STRUCTURED_SDK_LOG(sdmmc, Error, 2, ##__VA_ARGS__)
#define NN_DETAIL_SDMMC_ERROR_V3(...)               NN_DETAIL_STRUCTURED_SDK_LOG(sdmmc, Error, 3, ##__VA_ARGS__)

#define NN_DETAIL_SDMMC_FATAL(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(sdmmc, Fatal, 0, ##__VA_ARGS__)
#define NN_DETAIL_SDMMC_FATAL_V1(...)               NN_DETAIL_STRUCTURED_SDK_LOG(sdmmc, Fatal, 1, ##__VA_ARGS__)
#define NN_DETAIL_SDMMC_FATAL_V2(...)               NN_DETAIL_STRUCTURED_SDK_LOG(sdmmc, Fatal, 2, ##__VA_ARGS__)
#define NN_DETAIL_SDMMC_FATAL_V3(...)               NN_DETAIL_STRUCTURED_SDK_LOG(sdmmc, Fatal, 3, ##__VA_ARGS__)

#define NN_DETAIL_SDMMC_VTRACE(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(sdmmc, Trace, 0, format, args)
#define NN_DETAIL_SDMMC_VTRACE_V1(format, args)     NN_DETAIL_STRUCTURED_SDK_VLOG(sdmmc, Trace, 1, format, args)
#define NN_DETAIL_SDMMC_VTRACE_V2(format, args)     NN_DETAIL_STRUCTURED_SDK_VLOG(sdmmc, Trace, 2, format, args)
#define NN_DETAIL_SDMMC_VTRACE_V3(format, args)     NN_DETAIL_STRUCTURED_SDK_VLOG(sdmmc, Trace, 3, format, args)

#define NN_DETAIL_SDMMC_VINFO(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(sdmmc, Info, 0, format, args)
#define NN_DETAIL_SDMMC_VINFO_V1(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(sdmmc, Info, 1, format, args)
#define NN_DETAIL_SDMMC_VINFO_V2(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(sdmmc, Info, 2, format, args)
#define NN_DETAIL_SDMMC_VINFO_V3(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(sdmmc, Info, 3, format, args)

#define NN_DETAIL_SDMMC_VWARN(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(sdmmc, Warn, 0, format, args)
#define NN_DETAIL_SDMMC_VWARN_V1(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(sdmmc, Warn, 1, format, args)
#define NN_DETAIL_SDMMC_VWARN_V2(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(sdmmc, Warn, 2, format, args)
#define NN_DETAIL_SDMMC_VWARN_V3(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(sdmmc, Warn, 3, format, args)

#define NN_DETAIL_SDMMC_VERROR(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(sdmmc, Error, 0, format, args)
#define NN_DETAIL_SDMMC_VERROR_V1(format, args)     NN_DETAIL_STRUCTURED_SDK_VLOG(sdmmc, Error, 1, format, args)
#define NN_DETAIL_SDMMC_VERROR_V2(format, args)     NN_DETAIL_STRUCTURED_SDK_VLOG(sdmmc, Error, 2, format, args)
#define NN_DETAIL_SDMMC_VERROR_V3(format, args)     NN_DETAIL_STRUCTURED_SDK_VLOG(sdmmc, Error, 3, format, args)

#define NN_DETAIL_SDMMC_VFATAL(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(sdmmc, Fatal, 0, format, args)
#define NN_DETAIL_SDMMC_VFATAL_V1(format, args)     NN_DETAIL_STRUCTURED_SDK_VLOG(sdmmc, Fatal, 1, format, args)
#define NN_DETAIL_SDMMC_VFATAL_V2(format, args)     NN_DETAIL_STRUCTURED_SDK_VLOG(sdmmc, Fatal, 2, format, args)
#define NN_DETAIL_SDMMC_VFATAL_V3(format, args)     NN_DETAIL_STRUCTURED_SDK_VLOG(sdmmc, Fatal, 3, format, args)

#define NN_DETAIL_SDMMC_PUT_TRACE(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(sdmmc, Trace, 0, text, length)
#define NN_DETAIL_SDMMC_PUT_TRACE_V1(text, length)  NN_DETAIL_STRUCTURED_SDK_PUT(sdmmc, Trace, 1, text, length)
#define NN_DETAIL_SDMMC_PUT_TRACE_V2(text, length)  NN_DETAIL_STRUCTURED_SDK_PUT(sdmmc, Trace, 2, text, length)
#define NN_DETAIL_SDMMC_PUT_TRACE_V3(text, length)  NN_DETAIL_STRUCTURED_SDK_PUT(sdmmc, Trace, 3, text, length)

#define NN_DETAIL_SDMMC_PUT_INFO(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(sdmmc, Info, 0, text, length)
#define NN_DETAIL_SDMMC_PUT_INFO_V1(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(sdmmc, Info, 1, text, length)
#define NN_DETAIL_SDMMC_PUT_INFO_V2(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(sdmmc, Info, 2, text, length)
#define NN_DETAIL_SDMMC_PUT_INFO_V3(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(sdmmc, Info, 3, text, length)

#define NN_DETAIL_SDMMC_PUT_WARN(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(sdmmc, Warn, 0, text, length)
#define NN_DETAIL_SDMMC_PUT_WARN_V1(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(sdmmc, Warn, 1, text, length)
#define NN_DETAIL_SDMMC_PUT_WARN_V2(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(sdmmc, Warn, 2, text, length)
#define NN_DETAIL_SDMMC_PUT_WARN_V3(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(sdmmc, Warn, 3, text, length)

#define NN_DETAIL_SDMMC_PUT_ERROR(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(sdmmc, Error, 0, text, length)
#define NN_DETAIL_SDMMC_PUT_ERROR_V1(text, length)  NN_DETAIL_STRUCTURED_SDK_PUT(sdmmc, Error, 1, text, length)
#define NN_DETAIL_SDMMC_PUT_ERROR_V2(text, length)  NN_DETAIL_STRUCTURED_SDK_PUT(sdmmc, Error, 2, text, length)
#define NN_DETAIL_SDMMC_PUT_ERROR_V3(text, length)  NN_DETAIL_STRUCTURED_SDK_PUT(sdmmc, Error, 3, text, length)

#define NN_DETAIL_SDMMC_PUT_FATAL(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(sdmmc, Fatal, 0, text, length)
#define NN_DETAIL_SDMMC_PUT_FATAL_V1(text, length)  NN_DETAIL_STRUCTURED_SDK_PUT(sdmmc, Fatal, 1, text, length)
#define NN_DETAIL_SDMMC_PUT_FATAL_V2(text, length)  NN_DETAIL_STRUCTURED_SDK_PUT(sdmmc, Fatal, 2, text, length)
#define NN_DETAIL_SDMMC_PUT_FATAL_V3(text, length)  NN_DETAIL_STRUCTURED_SDK_PUT(sdmmc, Fatal, 3, text, length)
