﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_BitTypes.h>
#include <nn/ro/detail/ro_RoModule.h>
#include <nn/util/util_TypedStorage.h>

namespace nn { namespace rocrt {

const nn::Bit32 ModuleHeaderVersion = 0x30444F4D; // "MOD0";

struct ModuleHeader
{
    uint32_t signature;
    uint32_t dynamicOffset;
    uint32_t bssStartOffset;
    uint32_t bssEndOffset;
    uint32_t exceptionInfoStartOffset;
    uint32_t exceptionInfoEndOffset;
    uint32_t moduleOffset;
};

struct ModuleHeaderLocation
{
    nn::Bit32  padding;
    uint32_t   headerOffset;
};

inline Bit32 CheckModuleHeaderSignature(const ModuleHeader* pHeader) NN_NOEXCEPT
{
    if (pHeader->signature == ModuleHeaderVersion)
    {
        return pHeader->signature;
    }
    return 0;
}

inline ModuleHeader* GetModuleHeader(const ModuleHeaderLocation* pHeader) NN_NOEXCEPT
{
    return reinterpret_cast<ModuleHeader*>(
            reinterpret_cast<uintptr_t>(pHeader) + pHeader->headerOffset);
}

inline uintptr_t GetBssBeginAddress(const ModuleHeader* pHeader, const ModuleHeaderLocation* pLocation) NN_NOEXCEPT
{
    return reinterpret_cast<uintptr_t>(pLocation) + pLocation->headerOffset + pHeader->bssStartOffset;
}

inline uintptr_t GetBssEndAddress(const ModuleHeader* pHeader, const ModuleHeaderLocation* pLocation) NN_NOEXCEPT
{
    return reinterpret_cast<uintptr_t>(pLocation) + pLocation->headerOffset + pHeader->bssEndOffset;
}

inline uintptr_t GetModuleOffset(const ModuleHeader* pHeader, const ModuleHeaderLocation* pLocation) NN_NOEXCEPT
{
    return reinterpret_cast<uintptr_t>(pLocation) + pLocation->headerOffset + pHeader->moduleOffset;
}

inline uintptr_t GetDynamicOffset(const ModuleHeader* pHeader,  const ModuleHeaderLocation* pLocation) NN_NOEXCEPT
{
    return reinterpret_cast<uintptr_t>(pLocation) + pLocation->headerOffset + pHeader->dynamicOffset;
}

extern nn::util::TypedStorage<nn::ro::detail::RoModule, sizeof(nn::ro::detail::RoModule), NN_ALIGNOF(nn::ro::detail::RoModule)> g_RoModule;
}}
