﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_BitTypes.h>
#include <nn/util/util_IntrusiveList.h>
#include <nn/ro/detail/ro_Elf.h>

namespace nn { namespace ro {
namespace detail {
class RoModule: public nn::util::IntrusiveListBaseNode<RoModule>
{
public:
    Elf::Sym* Lookup(const char* pName) const NN_NOEXCEPT;
    Elf::Addr BindLazy(uint32_t index) NN_NOEXCEPT;
    void Relocation(bool lazyBind) NN_NOEXCEPT;
    void FixRelative() NN_NOEXCEPT;
    void Initialize(uintptr_t base, size_t moduleSize, const Elf::Dyn* pDynamicSection) NN_NOEXCEPT;
    uintptr_t GetBase() const NN_NOEXCEPT
    {
        return m_Base;
    }
    void CallInit() NN_NOEXCEPT;
    void CallFini() NN_NOEXCEPT;
    void RevertReference(RoModule* module) NN_NOEXCEPT;
    void BindVariables(const RoModule* pNewModule) NN_NOEXCEPT;
    const char* GetSoname() const NN_NOEXCEPT
    {
        if( m_SonameOffset != 0 )
        {
            return m_pStrTab + m_SonameOffset;
        }
        return nullptr;
    }
    bool IsAddressWithinModule(uintptr_t address) const NN_NOEXCEPT
    {
        if (address >= m_Base && address < m_Base + m_ModuleSize)
        {
            return true;
        }
        return false;
    }


private:
    bool ResolveSym(Elf::Addr* pOutAddress, const Elf::Sym sym) const NN_NOEXCEPT;
    void RestoreVariable(RoModule* module) NN_NOEXCEPT;
    void RestoreFunction(RoModule* module) NN_NOEXCEPT;

    union
    {
        Elf::Rel*   rel;
        Elf::Rela*  rela;
    }
    m_pPlt;

    union
    {
        Elf::Rel*   rel;
        Elf::Rela*  rela;
    }
    m_pDyn;

    uintptr_t       m_Base;
    const Elf::Dyn* m_pDynamicSection;
    bool            m_IsPltRela;
    size_t          m_PltRelSz;
    void            (*m_pInit)();
    void            (*m_pFini)();
    const Bit32*    m_pBuckets;
    const Bit32*    m_pChains;
    const char*     m_pStrTab;
    Elf::Sym*       m_pDynSym;
    size_t          m_StrSz;
    Elf::Addr*      m_pGot;
    size_t          m_DynRelaSz;
    size_t          m_DynRelSz;
    size_t          m_RelCount;
    size_t          m_RelaCount;
    size_t          m_Symbols;
    size_t          m_HashSize;
    Elf::Addr       m_DefaultPltGot;
    uintptr_t       m_SonameOffset;
    size_t          m_ModuleSize;
};
typedef nn::util::IntrusiveList<RoModule, nn::util::IntrusiveListBaseNodeTraits<RoModule>> RoModuleList;

uintptr_t Bind(RoModule* pModule, uint32_t index) NN_NOEXCEPT;
uintptr_t LookupGlobalManual(const char* pName) NN_NOEXCEPT;

extern RoModuleList* g_pAutoLoadList;
extern RoModuleList* g_pManualLoadList;
typedef uintptr_t (*LookupGlobalAutoFunctionPointer)(const char* pName);
extern LookupGlobalAutoFunctionPointer g_pLookupGlobalAutoFunctionPointer;
typedef uintptr_t (*LookupGlobalManualFunctionPointer)(const char* pName);
extern LookupGlobalManualFunctionPointer* g_pLookupGlobalManualFunctionPointer;

}
}}
