﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/TargetConfigs/build_Base.h>
#include <nn/rocrt/rocrt.h>
#include <nn/util/util_BitUtil.h>
#include <nn/os.h>

#include "ro_Elf32.h"
#include "ro_Elf64.h"
#include "ro_ModuleId.h"

namespace nn { namespace ro {
namespace detail {

    struct RocrtHeader
    {
        rocrt::ModuleHeaderLocation moduleHeaderLocation;
        NN_PADDING8;
    };
    NN_STATIC_ASSERT( sizeof(RocrtHeader) == 0x10 );

    class NroHeader
    {
    public:
        static const Bit32  SignatureValue0         = 0x304F524E; // NRO0
        static const size_t SegmentAlignSize        = 0x1000;
        static const size_t BssAlignSize            = 0x10;
        static const int    ModuleIdOffset          = 0x40;

    public:
        // バージョンが複数ある場合に、どのバージョンかを受け側で判定できるように値を返す。
        // 見つからないときは 0 を返す
        Bit32 CheckSignature() const NN_NOEXCEPT
        {
            if (m_Signature == SignatureValue0)
            {
                return m_Signature;
            }
            return 0;
        }

        const rocrt::ModuleHeaderLocation* GetRocrtModuleHeaderLocation() const NN_NOEXCEPT
        {
            return &m_Rocrt.moduleHeaderLocation;
        }

        uint32_t GetSize() const NN_NOEXCEPT
        {
            return m_Size;
        }

        uint32_t GetTextOffsetAddress() const NN_NOEXCEPT
        {
            return m_TextArrangeOffset;
        }

        uint32_t GetTextSize() const NN_NOEXCEPT
        {
            return m_TextSize;
        }

        uint32_t GetRoOffsetAddress() const NN_NOEXCEPT
        {
            return m_RodataArrangeOffset;
        }

        uint32_t GetRoSize() const NN_NOEXCEPT
        {
            return m_RodataSize;
        }

        uint32_t GetDataOffsetAddress() const NN_NOEXCEPT
        {
            return m_DataArrangeOffset;
        }

        uint32_t GetDataSize() const NN_NOEXCEPT
        {
            return m_DataSize;
        }

        uint32_t GetBssSize() const NN_NOEXCEPT
        {
            return m_BssSize;
        }

        const ModuleId* GetModuleId() const NN_NOEXCEPT
        {
            return &m_ModuleId;
        }

        Bit32 GetVersion() const NN_NOEXCEPT
        {
            return m_Version;
        }

        Bit32 GetFlags() const NN_NOEXCEPT
        {
            return m_Flags;
        }

        const uint32_t GetDsoHandleOffset() const NN_NOEXCEPT
        {
            return m_DsoHandleOffset;
        }

    private:
        RocrtHeader     m_Rocrt;
        Bit32           m_Signature;
        Bit32           m_Version;
        uint32_t        m_Size;
        Bit32           m_Flags;

        uint32_t        m_TextArrangeOffset;
        uint32_t        m_TextSize;
        uint32_t        m_RodataArrangeOffset;
        uint32_t        m_RodataSize;

        uint32_t        m_DataArrangeOffset;
        uint32_t        m_DataSize;
        uint32_t        m_BssSize;
        NN_PADDING4;

        ModuleId        m_ModuleId;
        uint32_t        m_DsoHandleOffset;
        Bit8            m_Reserved[0x1c] NN_IS_UNUSED_MEMBER;

    };

    NN_STATIC_ASSERT( sizeof(NroHeader) == 0x80 );

} // detail
}} // nn::ro

