﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Result.h>
#include <nn/os/os_Types.h>
#include <nn/ncm/ncm_ProgramId.h>

namespace nn { namespace pm {

    namespace detail
    {
        const char PortNameForInformation[] = "pm:info";
    }

    Result InitializeForInformation() NN_NOEXCEPT;
    Result FinalizeForInformation() NN_NOEXCEPT;

    Result GetProgramId(ncm::ProgramId* pOut, nn::os::ProcessId processId) NN_NOEXCEPT;

}}  // namespace nn::pm
