﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/pinmux/pinmux_IManager.sfdl.h>

namespace nn { namespace pinmux { namespace server {

/**
* @brief PINMUX のサービスオブジェクトを取得します。
*
* @return   サービスオブジェクト
*
* @detail
*   PINMUX のサービスオブジェクトを取得します。 @n
*/
nn::sf::SharedPointer<nn::pinmux::IManager> GetServiceObject() NN_NOEXCEPT;

/**
* @brief PINMUX の HIPC サーバを登録します。
*
* @pre
*   - HIPC サーバが未登録
*
* @post
*   - HIPC サーバが登録済
*
* @detail
*   PINMUX の HIPC サーバを登録します。 @n
*   この関数は、サーバを実体化するプロセスのメインスレッドのなるべく最初の段階で呼んでください。
*/
void RegisterHipcServer() NN_NOEXCEPT;

/**
* @brief PINMUX の HIPC サーバの処理を開始します。
*
* @pre
*   - HIPC サーバが登録済
*   - HIPC サーバが開始前
*
* @post
*   - HIPC サーバが開始済
*
* @detail
*   PINMUX の HIPC サーバの処理を開始します。
*/
void StartHipcServer() NN_NOEXCEPT;

/**
* @brief PINMUX の HIPC サーバの処理をループします。
*
* @pre
*   - HIPC サーバが登録済
*   - HIPC サーバが開始済
*
* @detail
*   PINMUX の HIPC サーバの処理をループします。 @n
*   この関数は別スレッドから StopHipcServer() が呼ばれるまで返りません。
*/
void LoopHipcServer() NN_NOEXCEPT;

/**
* @brief PINMUX の HIPC サーバ処理のループの中止をリクエストします。
*
* @pre
*   - HIPC サーバが登録済
*   - HIPC サーバが開始済
*
* @post
*   - HIPC サーバが開始前
*
* @detail
*   PINMUX の HIPC サーバ処理のループの中止をリクエストします。 @n
*   中止に成功すると、 LoopHipcServer() を呼び出してブロックしていたスレッドの処理が返ります。
*/
void StopHipcServer() NN_NOEXCEPT;

}}}
