﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

namespace nn {
namespace pinmux {

/**
* @brief 検査向けに変更可能なピングループの名前
*
* @details Generic spec の Pinmux ライブラリで検査向けに変更可能なピングループの定義です。
*/
enum AssignablePinGroupNameForHardwareTest
{
    AssignablePinGroupNameForHardwareTest_Dummy  = -1, //!< Dummy
};

/**
* @brief 検査向けにピンアサインできる機能
*
* @details Generic spec の Pinmux ライブラリで検査向けにピンアサイン可能な定義です。
*/
enum PinAssignmentForHardwareTest
{
    PinAssignmentForHardwareTest_Dummy               = -1, //!< Dummy
};

} //pinmux
} //nn
