﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   Pinmux ライブラリのプライベート API 宣言。
 */

#pragma once

#include <nn/nn_Common.h>

namespace nn {
namespace pinmux {
namespace driver {

/**
 * @brief 各ボードごとの初期設定値に Pinmux を一括設定します。
 *
 * @pre         ライブラリが初期化済みである。
 * @post        各ボードごとの初期値に Pinmux が設定された状態となります。
 * @details     Pinmux を各ボードごとの初期値に一括して設定します。@n
 *              本 API は特定のプロセスだけで使用される API です。許可なく使用しないでください。
 */
void SetInitialConfig() NN_NOEXCEPT;

/**
 * @brief 各ボードごとの初期設定値に DrivePad を一括設定します。
 *
 * @pre         ライブラリが初期化済みである。
 * @post        各ボードごとの初期値に DrivePad が設定された状態となります。
 * @details     DrivePad を各ボードごとの初期値に一括して設定します。@n
 *              本 API は特定のプロセスだけで使用される API です。許可なく使用しないでください。
 */
void SetInitialDrivePadConfig() NN_NOEXCEPT;

} // driver
} // pinmux
} // nn


