﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
    @file
    @brief 通知ライブラリで共通で使用する型を提供します。
*/

#include <nn/nn_Common.h>
#include <type_traits>

/**
    @namespace nn::ovln
    @brief 通知ライブラリのための名前空間です。
*/
namespace nn { namespace ovln {

/**
    @brief メッセージを表す型です。

    @details
     メッセージは以下のデータを持ちます。

     - タグ: 32bit 符号なし整数
     - ユーザデータ: 最大 120 バイトのユーザデータ (8 バイトアライン)

     メッセージを作成する場合には、

     - tag
     - dataSize
     - data

     のそれぞれのメンバを適切に指定してください。
     dataSize メンバには 0 から 120 の値を指定します。
     data には dataSize の長さだけデータをコピーしてください。
*/
struct Message
{
    uint32_t tag;
    uint32_t dataSize;
    std::aligned_storage<120, 8>::type data;
};

}}
