﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <type_traits>
#include <nn/nn_Common.h>
#include <nn/util/util_BitFlagSet.h>

namespace nn { namespace capsrv {

    struct AlbumFileId;

}}

namespace nn { namespace ovln { namespace format {

    const uint32_t ContinuousRecordingStartedDataTag = 8100;
    const uint32_t ContinuousRecordingNotEnabledDataTag = 8101;
    const uint32_t ContinuousRecordingNotPermittedDataTag = 8102;
    const uint32_t ContinuousRecordingErrorDataTag = 8103;
    const uint32_t ContinuousRecordingFlushSuccessDataTag = 8104;
    const uint32_t ContinuousRecordingFlushFailedDataTag = 8105;

    enum class ContinuousRecordingTrigger : uint8_t
    {
        CaptureButtonPressed = 0,
        SaveApiCalledByApplication = 1,
    };

    enum class ContinuousRecordingResult : uint8_t
    {
        Success = 0,
        AlbumIsFull = 1,
        AlbumFileCountLimit = 2,
        AlbumFileSystemError = 3,
    };

    /**
        @brief 常時録画撮影のオーバレイ通知用データ構造体です。

        @details
         以下の DataTag の際にこの構造体のデータが付与されます。

         - ContinuousRecordingStartedDataTag
         - ContinuousRecordingFlushFailedDataTag
         - ContinuousRecordingFlushSuccessDataTag

         これ以外の DataTag の際には、付加データは付与されません。
    */
    struct ContinuousRecordingData
    {
        /**
            @brief 撮影結果です。

            @details
             ContinuousRecordingStartedDataTag および ContinuousRecordingFlushSuccessDataTag の際には、ScreenShotResult::Success が固定で入ります。
             ContinuousRecordingFlushFailedDataTag の際には、エラーに応じた値が入ります。
        */
        ContinuousRecordingResult result;

        // 内部用メンバーです。直接アクセスしないでください。
        char reserved_[6];
        std::aligned_storage<24, 8>::type _entry;
        char reserved2_[32];

        /**
            @brief サムネイル取得用の AlbumFileId を取得します。
        */
        const nn::capsrv::AlbumFileId& GetAlbumFileId() const
        {
            return *reinterpret_cast<const nn::capsrv::AlbumFileId*>(&_entry);
        }
    };
    static_assert(sizeof(ContinuousRecordingData) == 64, "");
    static_assert(NN_ALIGNOF(ContinuousRecordingData) == 8, "");

}}}
