﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   スレッド情報の取得に関する型や定数の宣言
 */

#pragma once

#include <nn/nn_Macro.h>
#include <nn/nn_Common.h>

#include <nn/svc/svc_Base.h>
#include <nn/svc/svc_Dmnt.h>
#include <nn/svc/svc_Handle.h>

namespace nn { namespace osdbg { namespace detail {

    union   ThreadTypeCommon;

}}} // namespace nn::odbgs::detail


namespace nn { namespace osdbg {

//-----------------------------------------------------------------------------
/**
 * @brief   スレッド情報を格納する構造体です。
 *
 * @details
 *  デバッグモニタは ThreadInfo 構造体を利用して OS スレッド情報を取得する
 *  ことが出来ます。個々のメンバへは直接アクセスしないで下さい。
 */
struct  ThreadInfo
{
    int             _basePriority;
    int             _currentPriority;

    size_t          _stackSize;
    uintptr_t       _stack;
    uintptr_t       _argument;
    uintptr_t       _function;
    uintptr_t       _namePointer;

    // 管理用
    detail::ThreadTypeCommon*           _threadType;
    nn::svc::Handle                     _debugHandle;
    nn::svc::DebugInfoCreateProcess     _debugInfoCreateProcess;
    nn::svc::DebugInfoCreateThread      _debugInfoCreateThread;
};

//-----------------------------------------------------------------------------

}} // namespace nn::osdbg

