﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/osdbg/osdbg_Result.h>
#include <nn/osdbg/osdbg_ThreadTypes.h>


namespace nn { namespace osdbg {

//-----------------------------------------------------------------------------

inline int GetThreadPriority(const ThreadInfo* pThreadInfo) NN_NOEXCEPT
{
    return pThreadInfo->_basePriority;
}

inline int GetThreadCurrentPriority(const ThreadInfo* pThreadInfo) NN_NOEXCEPT
{
    return pThreadInfo->_currentPriority;
}

inline uintptr_t GetThreadNamePointer(const ThreadInfo* pThreadInfo) NN_NOEXCEPT
{
    return pThreadInfo->_namePointer;
}

inline uintptr_t GetThreadStackAddress(const ThreadInfo* pThreadInfo) NN_NOEXCEPT
{
    return pThreadInfo->_stack;
}

inline size_t GetThreadStackSize(const ThreadInfo* pThreadInfo) NN_NOEXCEPT
{
    return pThreadInfo->_stackSize;
}

inline uintptr_t GetThreadFunction(const ThreadInfo* pThreadInfo) NN_NOEXCEPT
{
    return pThreadInfo->_function;
}

inline uintptr_t GetThreadFunctionArgument(const ThreadInfo* pThreadInfo) NN_NOEXCEPT
{
    return pThreadInfo->_argument;
}


//-----------------------------------------------------------------------------

}}  // namespace nn::osdbg

