﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   コンパイラもしくは標準ライブラリ実装 API の宣言
 *
 * @details
 *  このヘッダファイルに含まれる API は全て RYNDA 向けであり、
 *  一般公開はされません。
 *
 */

#pragma once

#include <nn/nn_Common.h>

//! @name   コンパイラもしくは標準ライブラリ実装におけるプロセス制御関連
//! @{

//--------------------------------------------------------------------------
/**
 * @brief 自プロセスを終了します。
 *
 * @details
 *  自プロセスを強制的に終了します。本 API からはリターンしません。
 *
 *  本関数は C リンケージです。@n
 *  また、本関数はコンパイラが生成するコード、もしくは標準 C/C++ ランタイム
 *  ライブラリ内からのみ使用することを想定した関数です。一般公開はされません。
 *
 */
extern "C" NN_NORETURN void nnosExitProcess();

//! @}

