﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   メモリ属性設定機能に関する API の宣言
 */

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>

//--------------------------------------------------------------------------
//  C++ 向けの宣言
//--------------------------------------------------------------------------

namespace nn { namespace os {

//! @name メモリ属性関連 API
//! @{

//--------------------------------------------------------------------------
/**
 * @brief   メモリ属性を表す列挙型です。
 */
enum MemoryAttribute
{
    MemoryAttribute_Normal,   //!< 特別な属性を持たないことを表します。
    MemoryAttribute_Uncached  //!< 非キャッシュ領域であることを表します。
};


//--------------------------------------------------------------------------
/**
 * @brief   指定されたメモリ領域の属性を変更します。
 *
 * @param[in] address   設定したいメモリ領域の先頭アドレス
 * @param[in] size      設定したいメモリ領域のサイズ
 * @param[in] attribute 設定したいメモリ領域の属性
 *
 * @pre
 *  - address が nn::os::MemoryPageSize の整数倍である
 *  - size    が nn::os::MemoryPageSize の整数倍である
 *  - 指定するメモリ領域は通常のメモリ状態である
 *
 * @post
 *  - 指定されたメモリ領域の属性が attribute である
 *
 * @details
 *  指定されたメモリ領域の属性を attribute に変更します。
 *
 */
void SetMemoryAttribute(uintptr_t address, size_t size, MemoryAttribute attribute)  NN_NOEXCEPT;

//! @}

}} // namespace nn::os

