﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// TORIAEZU: osl 内部に定義する

#include <nn/nn_Common.h>
#include <nn/net/osl/osl_CLibraryUtil.h>

#ifdef __cplusplus

namespace nn { namespace net { namespace osl {

    /*!
        @brief pSrc が指す文字列を、size - 1 文字を超えない長さだけ pDst にコピーし、
        pDst を NUL 終端します。strlcpy と同一です。

        @param[out]   pDst     結果を格納するバッファを指定します。
        @param[in]    pSrc     コピー元の文字列を指定します。
        @param[in]    size     pDst のバッファ長を指定します。

        @return pSrc が指す文字列の長さ（NULを含まない）
    */
    size_t StrlCpy(char * pDst, const char* pSrc, size_t size );

}}}

#endif

NN_EXTERN_C size_t nnnetOslStrlCpy(char* dst, const char* src, size_t len);
