﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_SdkAssert.h>

namespace nn { namespace net { namespace osl {

template <class Derived>
class Singleton
{
    NN_DISALLOW_COPY(Singleton);
public:
    static Derived& GetInstance()
    {
        NN_SDK_ASSERT(g_Singleton);
        return(*g_Singleton);
    }

protected:
    Singleton()
    {
        NN_SDK_ASSERT(g_Singleton == 0, "This singleton constructor is called twice.");
        g_Singleton = static_cast<Derived*>(this);
    }

    ~Singleton()
    {
        NN_SDK_ASSERT(g_Singleton);
        g_Singleton = 0;
    }

private:
    static Derived* g_Singleton;
};

template <class Derived> Derived* Singleton <Derived>::g_Singleton = 0;

}}}

