﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// TORIAEZU: osl 内部に定義する

#include <cstdarg>
#include <nn/nn_Common.h>
#include <nn/net/osl/osl_CLibraryUtil.h>

#ifdef __cplusplus

namespace nn { namespace net { namespace osl {

/*!
    @brief 文字列を出力します。vsnprintf の省メモリ版です。
    @param[out]   dst     結果を格納するバッファを指定します。
    @param[in]    len     dst のバッファ長を指定します。
    @param[in]    fmt     一般的な printf のフォーマット文字列を指定します。ただし、浮動小数点系のもの(%%f など) は指定できません。
    @param[in]    vlist   パラメータを指定します。

    @return 書式文字列を正しく出力した場合の文字数を返します。
*/
int32_t TVSNPrintf(char *dst, size_t len, const char *fmt, va_list vlist);

/*!
    @brief 文字列を出力します。vsnprintf の省メモリ版です。

    こちらは、wchar_t 版です。

    @param[out]   dst     結果を格納するバッファを指定します。
    @param[in]    len     dst のバッファ長を指定します。
    @param[in]    fmt     一般的な printf のフォーマット文字列を指定します。ただし、浮動小数点系のもの(%%f など) は指定できません。
    @param[in]    vlist   パラメータを指定します。

    @return 書式文字列を正しく出力した場合の文字数を返します。
*/
int32_t TVSNPrintf(wchar_t *dst, size_t len, const wchar_t *fmt, va_list vlist);

/*!
    @brief 文字列を出力します。snprintf の省メモリ版です。
    @param[out]   dst     結果を格納するバッファを指定します。
    @param[in]    len     dst のバッファ長を指定します。
    @param[in]    fmt     一般的な printf のフォーマット文字列を指定します。ただし、浮動小数点系のもの(%%f など) は指定できません。
    @param[in]    ...     フォーマット文字列に対応する引数を指定します。

    @return 書式文字列を正しく出力した場合の文字数を返します。
*/
int32_t TSNPrintf(char *dst, size_t len, const char *fmt, ...);

/*!
    @brief 文字列を出力します。snprintf の省メモリ版です。

    こちらは、wchar_t 版です。

    @param[out]   dst     結果を格納するバッファを指定します。
    @param[in]    len     dst のバッファ長を指定します。
    @param[in]    fmt     一般的な printf のフォーマット文字列を指定します。ただし、浮動小数点系のもの(%%f など) は指定できません。
    @param[in]    ...     フォーマット文字列に対応する引数を指定します。

    @return 書式文字列を正しく出力した場合の文字数を返します。
*/
int32_t TSNPrintf(wchar_t *dst, size_t len, const wchar_t *fmt, ...);

/*!
    @brief 文字列を出力します。sprintf の省メモリ版です。
    @param[out]   dst     結果を格納するバッファを指定します。
    @param[in]    fmt     一般的な printf のフォーマット文字列を指定します。ただし、浮動小数点系のもの(%%f など) は指定できません。
    @param[in]    ...     フォーマット文字列に対応する引数を指定します。

    @return 書式文字列を正しく出力した場合の文字数を返します。
*/
int32_t TSPrintf(char *dst, const char *fmt, ...);

/*!
    @brief 文字列を出力します。sprintf の省メモリ版です。

    こちらは、wchar_t 版です。

    @param[out]   dst     結果を格納するバッファを指定します。
    @param[in]    fmt     一般的な printf のフォーマット文字列を指定します。ただし、浮動小数点系のもの(%%f など) は指定できません。
    @param[in]    ...     フォーマット文字列に対応する引数を指定します。

    @return 書式文字列を正しく出力した場合の文字数を返します。
*/
int32_t TSPrintf(wchar_t *dst, const wchar_t *fmt, ...);

}}}

#endif

// 以下、C 用宣言

NN_EXTERN_C int32_t nnnetOslTVSNPrintf(char *dst, size_t len, const char *fmt, va_list vlist);
NN_EXTERN_C int32_t nnnetOslTSNPrintf(char *dst, size_t len, const char *fmt, ...);
NN_EXTERN_C int32_t nnnetOslTSPrintf(char *dst, const char *fmt, ...);
NN_EXTERN_C int32_t nnnetOslTVSNWPrintf(wchar_t *dst, size_t len, const wchar_t *fmt, va_list vlist);
NN_EXTERN_C int32_t nnnetOslTSNWPrintf(wchar_t *dst, size_t len, const wchar_t *fmt, ...);
NN_EXTERN_C int32_t nnnetOslTSWPrintf(wchar_t *dst, const wchar_t *fmt, ...);
