﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file nsoc_entry.h
 * NSOC_GetInstanceOpt(), NSOC_SetInstanceOpt()で使用する情報構造体
 */

#ifndef NN_NET_COMPATIBLE_NSOC_NSOC_ENTRY_H_
#define NN_NET_COMPATIBLE_NSOC_NSOC_ENTRY_H_

#include <nn/net/nos/nos_compatible.h>
#include <nn/net/nsoc/nsoc_user.h>	/* for NSOC_IP_ALEN, NSOC_ETH_ALEN */

#ifdef __cplusplus
extern "C" {
#endif

enum NSOCARPState {
    NSOC_ARP_STATE_INCOMPLETE              = 1, /**< ARP解決実行中状態 */
    NSOC_ARP_STATE_REACHABLE               = 2, /**< 到達可能状態 */
    NSOC_ARP_STATE_PROBE                   = 3  /**< 確認中状態 */
};

/**
 * NSOC_GetInstanceOpt(), NSOC_SetInstanceOpt()でNSOC_CONFIG_ARP_TABLE使用時の構造体
 */
typedef struct NSOCARPEntry
{
    int             state;                      /**< NSOC_ARP_STATE_*のいずれか */
    u8              prAddr[NSOC_IP_ALEN];       /**< IPアドレス */
    u8              hwAddr[NSOC_ETH_ALEN];      /**< MACアドレス */
    NN_PADDING2;
} NSOCARPEntry;


/**
 * NSOC_GetInstanceOpt(), NSOC_SetInstanceOpt()でNSOC_CONFIG_IP_ADDR_TABLE 使用時の構造体
 */
typedef struct NSOCIPAddrEntry
{
    u8              addr[NSOC_IP_ALEN];         /**< IPアドレス */
    u8              netMask[NSOC_IP_ALEN];      /**< サブネットマスク */
    u8              bcastAddr[NSOC_IP_ALEN];    /**< ブロードキャストアドレス */
} NSOCIPAddrEntry;

enum NSOCIPRouteFlag {
    NSOC_IP_ROUTE_FLAG_G                   = 0x01,    /**< ルータからの情報により作成 */
    NSOC_IP_ROUTE_FLAG_D                   = 0x02,    /**< ICMPにより作成 */
    NSOC_IP_ROUTE_FLAG_M                   = 0x04     /**< ICMPにより変更 */
};

/**
 * NSOC_GetInstanceOpt(), NSOC_SetInstanceOpt()でNSOC_CONFIG_IP_ROUTING_TABLE 使用時の構造体
 */
typedef struct NSOCIPRouteEntry
{
    u8           dst[NSOC_IP_ALEN];          /**< 宛先IPアドレス */
    u8           netmask[NSOC_IP_ALEN];      /**< サブネットマスク */
    u8           gateway[NSOC_IP_ALEN];      /**< next-hopゲートウエイ */
    u32          flag;                       /**< NSOC_IP_ROUTE_FLAG_XXX、NSOC_SetInstanceOpt()では0を指定してください。 */
    NOSTick      time;                       /**< 最後にアクセスされた時刻（tick）、NSOC_SetInstanceOpt()では0を指定してください。 */
} NSOCIPRouteEntry;

#ifdef NSOC_IP6_ENABLE
/**
 * NSOC_GetInstanceOpt(), NSOC_SetInstanceOpt()でNSOC_CONFIG_IP6_ADD_ROUTE 使用時の構造体
 */
typedef struct NSOCIP6RouteEntry
{
    u8              prefix[NSOC_IP6_ALEN];      /**< プレフィックス */
    u32             prefixLen;                  /**< プレフィックス長 */
    u32             flag;                       /**< NSOC_IP_ROUTE_FLAG_XXX、NSOC_SetInstanceOpt()では0を指定してください。 */
    u32             expireTime;                 /**< 期限切れとなる時刻（秒）、NSOC_SetInstanceOpt()時は0を指定してください。 */
} NSOCIP6RouteEntry;

/**
 * NSOC_GetInstanceOpt(), NSOC_SetInstanceOpt()でNSOC_CONFIG_IP6_ADD_ADDRESS、
 * NSOC_CONFIG_IP6_ADDR_TABLE 使用時の構造体
 */
typedef struct NSOCIP6MyAddrEntry
{
    u8              addr[NSOC_IP6_ALEN];    /**< アドレス */
    u32             preferredTime;          /**< Preferred Lifetime(秒) */
    u32             validTime;              /**< Valid Lifetime(秒) */
    u32             state;                  /**< 自アドレスの状態 NSOC_IP6_MYADR_ST_XXXX、NSOC_SetInstanceOpt()時は0を指定してください。 */
    BOOL            anycast;                /**< エニーキャストアドレスか否か */
} NSOCIP6MyAddrEntry;

/**
 * NSOC_GetInstanceOpt(), NSOC_SetInstanceOpt()でNSOC_CONFIG_IP6_ADD_PREFIX、
 * NSOC_CONFIG_IP6_PREFIX_TABLE 使用時の構造体
 */
typedef struct NSOCIP6PrefixEntry
{
    u8              prefix[NSOC_IP6_ALEN];  /**< プレフィックス */
    u32             prefixLen;              /**< プレフィックス長。NSOC_GetInstanceOpt()時は1-64のビット長で指定してください。 */
    u32             preferredTime;          /**< Preferred Lifetime(秒) */
    u32             validTime;              /**< Valid Lifetime(秒) */
    u8              flags;                  /**< NSOC_NDP_OPT_PI_FLAG_XXXXのいずれか */
} NSOCIP6PrefixEntry;

/**
 * NSOC_GetInstanceOpt()
 * NSOC_CONFIG_IP6_NEIGHBOR_CACHE_TABLE 使用時の構造体
 */
typedef struct NSOCIP6NeighborCacheEntry
{
    u8              addr[NSOC_IP6_ALEN];    /**< 近隣アドレス */
    u32             state;                  /**< キャッシュの状態 NSOC_NDP_NCST_XXXX */
    BOOL            isRouter;               /**< ルータか否か */
} NSOCIP6NeighborCacheEntry;

/**
 * NSOC_GetInstanceOpt()で
 * NSOC_CONFIG_IP6_DESTINATION_CACHE_TABLE 使用時の構造体
 */
typedef struct NSOCIP6DestinationCacheEntry
{
    u8              dst[NSOC_IP6_ALEN];     /**< 宛先アドレス */
    u8              nextHop[NSOC_IP6_ALEN]; /**< 次ホップアドレス */
    u32             pmtu;                   /**< パスMTU値 */
} NSOCIP6DestinationCacheEntry;

/**
 * NSOC_GetInstanceOpt()で
 * NSOC_CONFIG_IP6_DEFAULT_ROUTER_TABLE 使用時の構造体
 */
typedef struct NSOCIP6DefaultRouterEntry
{
    u8              addr[NSOC_IP6_ALEN];     /**< デフォルトルータアドレス */
} NSOCIP6DefaultRouterEntry;

#endif /* NSOC_IP6_ENABLE */

/**
 * NSOC_GetInstanceOpt(), NSOC_SetInstanceOpt()でNSOC_CONFIG_UDP_TABLE 使用時の構造体
 */
typedef struct NSOCUDPEntry
{
    NSOCSockAddrStorage    local;         /**< 自ソケットアドレス情報 */
    NSOCSockAddrStorage    remote;        /**< 相手先ソケットアドレス情報 */
} NSOCUDPEntry;


#define NSOC_TCP_STATE_CLOSED        1    /**< CLOSEDステート */
#define NSOC_TCP_STATE_LISTEN        2    /**< LISTENステート */
#define NSOC_TCP_STATE_SYN_SENT      3    /**< SYN_SENTステート */
#define NSOC_TCP_STATE_SYN_RECEIVED  4    /**< SYN_RECEIVED ステート */
#define NSOC_TCP_STATE_ESTABLISHED   5    /**< ESTABLISHEDステート */
#define NSOC_TCP_STATE_FINWAIT1      6    /**< FINWAIT_1ステート */
#define NSOC_TCP_STATE_FINWAIT2      7    /**< FINWAIT_2ステート */
#define NSOC_TCP_STATE_CLOSE_WAIT    8    /**< CLOSE_WAITステート */
#define NSOC_TCP_STATE_LAST_ACK      9    /**< LAST_ACKステート */
#define NSOC_TCP_STATE_CLOSING       10   /**< CLOSINGステート */
#define NSOC_TCP_STATE_TIME_WAIT     11   /**< TIME_WAITステート */

/**
 * NSOC_GetInstanceOpt(), NSOC_SetInstanceOpt()でNSOC_CONFIG_TCP_TABLE 使用時の構造体
 */
typedef struct NSOCTCPEntry
{
    s32                    state;         /**< NSOC_TCP_STATE_*のいずれか */
    NSOCSockAddrStorage    local;         /**< 自ソケットアドレス情報 */
    NSOCSockAddrStorage    remote;        /**< 相手先ソケットアドレス情報 */
} NSOCTCPEntry;

#ifdef __cplusplus
}
#endif

#endif  /* NN_NET_COMPATIBLE_NSOC_NSOC_ENTRY_H_ */
