﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * NNETモジュールのリングバッファ関連定義
 */

#ifndef NN_NET_COMPATIBLE_NNET_NNET_RING_H_
#define NN_NET_COMPATIBLE_NNET_NNET_RING_H_

#include <nn/net/nos.h>    /* for NOSMessageBuf */

#ifdef __cplusplus
extern "C" {
#endif

/**
 * データブロック構造体
 */
typedef struct NNETBlock {
    u8*   ptr;    /**< データの先頭ポインタ */
    s32   len;    /**< データ長 */
} NNETBlock;

/**
 * データベクタ構造体
 */
typedef struct NNETVec {
    void* data;    /**< データの先頭ポインタ */
    s32   len;     /**< データ長 */
} NNETVec;

u8*   NNET_RingIn ( u8* buf, s32 size, u8* head, s32 used, const u8* data, s32 len );
u8*   NNET_RingInMbuf ( u8* buf, s32 size, u8* head, s32 used, NOSMessageBuf *mbuf, s32 len );
u8*   NNET_RingInExMbuf( u8* buf, s32 size, u8* head, s32 used, s32 offset, NOSMessageBuf *mbuf, s32* plen, NNETBlock* blocks, s32 maxblock );
u8*   NNET_RingOut( u8* buf, s32 size, u8* head, s32 used, u8* data, s32 len );
int NNET_RingGet(u8* buf, s32 size, u8* head, s32 used, NNETVec* vec, s32 len);
int NNET_RingGetMbuf(u8* buf, s32 size, u8* head, s32 used, NOSMessageBuf *mbuf, s32 len);
u8*   NNET_RingPut( u8* buf, s32 size, u8* head, s32 used, s32 len );

#ifdef __cplusplus
}
#endif

#endif  /* NN_NET_COMPATIBLE_NNET_NNET_RING_H_ */
