﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NN_NET_COMPATIBLE_NLIB_NLIB_MD5_HORIZON_H_
#define NN_NET_COMPATIBLE_NLIB_NLIB_MD5_HORIZON_H_

/**
 * nlib_md5.hからインクルードされる
 */

#include <nn/net/nos/nos_compatible.h>

#ifdef  __cplusplus
extern "C" {
#endif

/**
 *  MD5コンテキスト
 */
typedef struct NLIBMD5Context
{
    union
    {
        struct
        {
            unsigned long a, b, c, d;
        } p;
        unsigned long state[4];
    } x;
    unsigned long long length;
    union
    {
        unsigned long buffer32[16];
        unsigned char buffer8[64];
    } y;
} NLIBMD5Context;

/*
    以下の関数を用意してください。
    ・Init関数
    ・Update関数
    ・Final関数
*/
void NLIB_MD5Init(NLIBMD5Context* context);
void NLIB_MD5Update(NLIBMD5Context* context, const void* input, u32 length);
void NLIB_MD5Final(u8 digest[20], NLIBMD5Context* context);

#ifdef  __cplusplus
}
#endif

#endif
