﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/util/util_StringUtil.h>

namespace nn { namespace ncm {

    const char StorageNameBuildInSystem[] = "system";
    const char StorageNameBuildInUser[] = "user";
    const char StorageNameBuildInSystemEmulation[] = "systemEmu";

    struct StorageName
    {
        char string[16];
    };

    inline StorageName MakeStorageName(const char* name) NN_NOEXCEPT
    {
        StorageName storageName = {};
        util::Strlcpy(storageName.string, name, sizeof(storageName.string));

        return storageName;
    }

    inline bool operator == (const StorageName& lhs, const StorageName& rhs) NN_NOEXCEPT
    {
        return util::Strncmp(lhs.string, rhs.string, sizeof(lhs.string)) == 0;
    }

}}
