﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

namespace nn { namespace ncm {

    enum class StorageId : Bit8
    {
        None,
        Host,          // 将来なくなる
        Card,
        BuildInSystem,
        BuildInUser,
        SdCard,
        Any,           // どのストレージでも良い

        GameCard = Card,
        BuiltInSystem = BuildInSystem,
        BuiltInUser = BuildInUser,
    };
    // インストール可能なストレージかどうか
    inline bool IsInstallableStorage(StorageId id) NN_NOEXCEPT
    {
        return id == StorageId::BuildInSystem || id == StorageId::BuildInUser || id == StorageId::SdCard || id == StorageId::Any;
    }
    // ひとつに決定できるストレージかどうか
    inline bool IsUniqueStorage(StorageId id) NN_NOEXCEPT
    {
        return id != StorageId::None && id != StorageId::Any;
    }
}}
