﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/ncm/ncm_AutoBuffer.h>
#include <nn/ncm/ncm_PackageInstallTaskBase.h>
#include <nn/ncm/ncm_ContentMetaDatabase.h>
#include <nn/kvdb/kvdb_BoundedString.h>

namespace nn { namespace ncm {

    class PackageSystemUpdateTask : public PackageInstallTaskBase
    {
    public:
        ~PackageSystemUpdateTask() NN_NOEXCEPT;

        Result Initialize(const char* packageRoot, const char* contextPath, void* buffer, size_t bufferSize, bool requiresExFatDriver) NN_NOEXCEPT;
        util::optional<ncm::ContentMetaKey> GetSystemUpdateMetaKey() NN_NOEXCEPT;

    protected:
        virtual Result PrepareInstallContentMetaData() NN_NOEXCEPT NN_OVERRIDE;

    private:
        typedef kvdb::BoundedString<256> InternalPath;
        InternalPath m_ContextPath;

        virtual Result PrepareDependency() NN_NOEXCEPT NN_OVERRIDE;
        virtual Result GetInstallContentMetaInfo(ncm::InstallContentMetaInfo* outValue, const ncm::ContentMetaKey& key) NN_NOEXCEPT NN_OVERRIDE;

        Result GetContentInfoOfContentMeta(ContentInfo* outValue, const ContentMetaKey& key) NN_NOEXCEPT;

        FileInstallTaskData m_Data;
        ContentMetaDatabase m_PackageDb;
    };
}}
