﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/util/util_TypedStorage.h>

namespace nn { namespace ncm {
    enum InstallProgressState : Bit8
    {
        NotPrepared,
        DataPrepared,
        Prepared,
        Downloaded,
        Commited,
        Fatal
    };

    struct InstallProgress
    {
        InstallProgressState state;
        Bit8 reserved[3];
        util::TypedStorage<Result, sizeof(Result), NN_ALIGNOF(Result)> lastResult;
        int64_t installedSize;
        int64_t totalSize;

        Result GetLastResult() const NN_NOEXCEPT
        {
            return util::Get(lastResult);
        }
    };
}}
