﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// このファイルは SFDL による自動生成ファイルです。
// 手動で変更しないでください。
// This file is auto-generated by the SFDL code generator.
// Do not modify manually.

#include <nn/ncm/ncm_IContentMetaDatabase.h>
#include <nn/ncm/ncm_IContentStorage.h>
#include <nn/ncm/ncm_StorageId.h>
#include <nn/nn_Result.h>
#include <nn/sf/cmif/detail/sf_CmifAutogenInterfaceIncludes.h>
#include <nn/sf/detail/sf_AutogenInterfaceIncludes.h>
#include <nn/sf/impl/detail/sf_AutogenImplIncludes.h>

namespace nn { namespace ncm { // NOLINT(whitespace/braces)

class IContentManager;

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IContentManager, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IContentManager)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CreateContentStorage, (::nn::ncm::StorageId storageId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CreateContentMetaDatabase, (::nn::ncm::StorageId storageId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(VerifyContentStorage, (::nn::ncm::StorageId storageId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(VerifyContentMetaDatabase, (::nn::ncm::StorageId storageId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(OpenContentStorage, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::ncm::IContentStorage>> outValue, ::nn::ncm::StorageId storageId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(OpenContentMetaDatabase, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::ncm::IContentMetaDatabase>> outValue, ::nn::ncm::StorageId storageId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CleanupContentMetaDatabase, (::nn::ncm::StorageId storageId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ActivateContentStorage, (::nn::ncm::StorageId storageId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(InactivateContentStorage, (::nn::ncm::StorageId storageId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ActivateContentMetaDatabase, (::nn::ncm::StorageId storageId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(InactivateContentMetaDatabase, (::nn::ncm::StorageId storageId))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IContentManager)

        ::nn::Result CreateContentStorage(::nn::ncm::StorageId storageId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CreateContentStorage, (storageId));
        }

        ::nn::Result CreateContentMetaDatabase(::nn::ncm::StorageId storageId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CreateContentMetaDatabase, (storageId));
        }

        ::nn::Result VerifyContentStorage(::nn::ncm::StorageId storageId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(VerifyContentStorage, (storageId));
        }

        ::nn::Result VerifyContentMetaDatabase(::nn::ncm::StorageId storageId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(VerifyContentMetaDatabase, (storageId));
        }

        ::nn::Result OpenContentStorage(::nn::sf::Out<::nn::sf::SharedPointer<::nn::ncm::IContentStorage>> outValue, ::nn::ncm::StorageId storageId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(OpenContentStorage, (outValue, storageId));
        }

        ::nn::Result OpenContentMetaDatabase(::nn::sf::Out<::nn::sf::SharedPointer<::nn::ncm::IContentMetaDatabase>> outValue, ::nn::ncm::StorageId storageId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(OpenContentMetaDatabase, (outValue, storageId));
        }

        ::nn::Result CleanupContentMetaDatabase(::nn::ncm::StorageId storageId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CleanupContentMetaDatabase, (storageId));
        }

        ::nn::Result ActivateContentStorage(::nn::ncm::StorageId storageId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ActivateContentStorage, (storageId));
        }

        ::nn::Result InactivateContentStorage(::nn::ncm::StorageId storageId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(InactivateContentStorage, (storageId));
        }

        ::nn::Result ActivateContentMetaDatabase(::nn::ncm::StorageId storageId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ActivateContentMetaDatabase, (storageId));
        }

        ::nn::Result InactivateContentMetaDatabase(::nn::ncm::StorageId storageId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(InactivateContentMetaDatabase, (storageId));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IContentManager
    {
    public:
        nn::Result CreateContentStorage(nn::ncm::StorageId storageId) NN_NOEXCEPT;
        nn::Result CreateContentMetaDatabase(nn::ncm::StorageId storageId) NN_NOEXCEPT;
        nn::Result VerifyContentStorage(nn::ncm::StorageId storageId) NN_NOEXCEPT;
        nn::Result VerifyContentMetaDatabase(nn::ncm::StorageId storageId) NN_NOEXCEPT;
        nn::Result OpenContentStorage(nn::sf::Out<nn::sf::SharedPointer<nn::ncm::IContentStorage>> outValue, nn::ncm::StorageId storageId) NN_NOEXCEPT;
        nn::Result OpenContentMetaDatabase(nn::sf::Out<nn::sf::SharedPointer<nn::ncm::IContentMetaDatabase>> outValue, nn::ncm::StorageId storageId) NN_NOEXCEPT;
        nn::Result CleanupContentMetaDatabase(nn::ncm::StorageId storageId) NN_NOEXCEPT;
        nn::Result ActivateContentStorage(nn::ncm::StorageId storageId) NN_NOEXCEPT;
        nn::Result InactivateContentStorage(nn::ncm::StorageId storageId) NN_NOEXCEPT;
        nn::Result ActivateContentMetaDatabase(nn::ncm::StorageId storageId) NN_NOEXCEPT;
        nn::Result InactivateContentMetaDatabase(nn::ncm::StorageId storageId) NN_NOEXCEPT;
    };
#endif

}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result CreateContentStorage(nn::ncm::StorageId storageId) NN_NOEXCEPT;
    nn::Result CreateContentMetaDatabase(nn::ncm::StorageId storageId) NN_NOEXCEPT;
    nn::Result VerifyContentStorage(nn::ncm::StorageId storageId) NN_NOEXCEPT;
    nn::Result VerifyContentMetaDatabase(nn::ncm::StorageId storageId) NN_NOEXCEPT;
    nn::Result OpenContentStorage(nn::sf::Out<nn::sf::SharedPointer<nn::ncm::IContentStorage>> outValue, nn::ncm::StorageId storageId) NN_NOEXCEPT;
    nn::Result OpenContentMetaDatabase(nn::sf::Out<nn::sf::SharedPointer<nn::ncm::IContentMetaDatabase>> outValue, nn::ncm::StorageId storageId) NN_NOEXCEPT;
    nn::Result CleanupContentMetaDatabase(nn::ncm::StorageId storageId) NN_NOEXCEPT;
    nn::Result ActivateContentStorage(nn::ncm::StorageId storageId) NN_NOEXCEPT;
    nn::Result InactivateContentStorage(nn::ncm::StorageId storageId) NN_NOEXCEPT;
    nn::Result ActivateContentMetaDatabase(nn::ncm::StorageId storageId) NN_NOEXCEPT;
    nn::Result InactivateContentMetaDatabase(nn::ncm::StorageId storageId) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::ncm::IContentManager))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateContentStorage, (::nn::ncm::StorageId storageId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CreateContentStorage, (storageId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateContentMetaDatabase, (::nn::ncm::StorageId storageId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CreateContentMetaDatabase, (storageId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(VerifyContentStorage, (::nn::ncm::StorageId storageId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(VerifyContentStorage, (storageId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(VerifyContentMetaDatabase, (::nn::ncm::StorageId storageId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(VerifyContentMetaDatabase, (storageId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenContentStorage, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::ncm::IContentStorage>> outValue, ::nn::ncm::StorageId storageId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(OpenContentStorage, (outValue, storageId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenContentMetaDatabase, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::ncm::IContentMetaDatabase>> outValue, ::nn::ncm::StorageId storageId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(OpenContentMetaDatabase, (outValue, storageId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CleanupContentMetaDatabase, (::nn::ncm::StorageId storageId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CleanupContentMetaDatabase, (storageId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ActivateContentStorage, (::nn::ncm::StorageId storageId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ActivateContentStorage, (storageId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(InactivateContentStorage, (::nn::ncm::StorageId storageId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(InactivateContentStorage, (storageId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ActivateContentMetaDatabase, (::nn::ncm::StorageId storageId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ActivateContentMetaDatabase, (storageId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(InactivateContentMetaDatabase, (::nn::ncm::StorageId storageId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(InactivateContentMetaDatabase, (storageId));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::ncm::IContentManager>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::ncm::IContentManager))

    // nn::Result CreateContentStorage(nn::ncm::StorageId storageId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CreateContentStorage)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(storageId, (::nn::ncm::StorageId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (storageId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(storageId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CreateContentStorage)

    // nn::Result CreateContentMetaDatabase(nn::ncm::StorageId storageId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CreateContentMetaDatabase)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(storageId, (::nn::ncm::StorageId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (storageId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(storageId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CreateContentMetaDatabase)

    // nn::Result VerifyContentStorage(nn::ncm::StorageId storageId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(VerifyContentStorage)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(storageId, (::nn::ncm::StorageId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (storageId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(storageId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(VerifyContentStorage)

    // nn::Result VerifyContentMetaDatabase(nn::ncm::StorageId storageId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(VerifyContentMetaDatabase)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(storageId, (::nn::ncm::StorageId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (storageId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(storageId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(VerifyContentMetaDatabase)

    // nn::Result OpenContentStorage(nn::sf::Out<nn::sf::SharedPointer<nn::ncm::IContentStorage>> outValue, nn::ncm::StorageId storageId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(OpenContentStorage)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outValue, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outValue))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(storageId, (::nn::ncm::StorageId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (storageId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(storageId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(OpenContentStorage)

    // nn::Result OpenContentMetaDatabase(nn::sf::Out<nn::sf::SharedPointer<nn::ncm::IContentMetaDatabase>> outValue, nn::ncm::StorageId storageId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(OpenContentMetaDatabase)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(5)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outValue, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outValue))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(storageId, (::nn::ncm::StorageId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (storageId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(storageId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(OpenContentMetaDatabase)

    // nn::Result CleanupContentMetaDatabase(nn::ncm::StorageId storageId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CleanupContentMetaDatabase)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(storageId, (::nn::ncm::StorageId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (storageId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(storageId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CleanupContentMetaDatabase)

    // nn::Result ActivateContentStorage(nn::ncm::StorageId storageId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ActivateContentStorage)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(9)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(storageId, (::nn::ncm::StorageId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (storageId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(storageId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ActivateContentStorage)

    // nn::Result InactivateContentStorage(nn::ncm::StorageId storageId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(InactivateContentStorage)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(10)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(storageId, (::nn::ncm::StorageId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (storageId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(storageId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(InactivateContentStorage)

    // nn::Result ActivateContentMetaDatabase(nn::ncm::StorageId storageId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ActivateContentMetaDatabase)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(11)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(storageId, (::nn::ncm::StorageId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (storageId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(storageId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ActivateContentMetaDatabase)

    // nn::Result InactivateContentMetaDatabase(nn::ncm::StorageId storageId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(InactivateContentMetaDatabase)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(12)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(storageId, (::nn::ncm::StorageId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (storageId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(storageId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(InactivateContentMetaDatabase)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ncm::StorageId), 1, 1)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::ncm::IContentManager, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::ncm::IContentManager))

    // nn::Result CreateContentStorage(nn::ncm::StorageId storageId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateContentStorage, (::nn::ncm::StorageId storageId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CreateContentStorage)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(storageId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CreateContentStorage)
    }

    // nn::Result CreateContentMetaDatabase(nn::ncm::StorageId storageId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateContentMetaDatabase, (::nn::ncm::StorageId storageId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CreateContentMetaDatabase)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(storageId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CreateContentMetaDatabase)
    }

    // nn::Result VerifyContentStorage(nn::ncm::StorageId storageId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(VerifyContentStorage, (::nn::ncm::StorageId storageId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(VerifyContentStorage)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(storageId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(VerifyContentStorage)
    }

    // nn::Result VerifyContentMetaDatabase(nn::ncm::StorageId storageId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(VerifyContentMetaDatabase, (::nn::ncm::StorageId storageId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(VerifyContentMetaDatabase)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(storageId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(VerifyContentMetaDatabase)
    }

    // nn::Result OpenContentStorage(nn::sf::Out<nn::sf::SharedPointer<nn::ncm::IContentStorage>> outValue, nn::ncm::StorageId storageId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenContentStorage, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::ncm::IContentStorage>> outValue, ::nn::ncm::StorageId storageId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(OpenContentStorage)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(storageId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(OpenContentStorage)
    }

    // nn::Result OpenContentMetaDatabase(nn::sf::Out<nn::sf::SharedPointer<nn::ncm::IContentMetaDatabase>> outValue, nn::ncm::StorageId storageId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenContentMetaDatabase, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::ncm::IContentMetaDatabase>> outValue, ::nn::ncm::StorageId storageId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(OpenContentMetaDatabase)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(storageId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(OpenContentMetaDatabase)
    }

    // nn::Result CleanupContentMetaDatabase(nn::ncm::StorageId storageId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CleanupContentMetaDatabase, (::nn::ncm::StorageId storageId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CleanupContentMetaDatabase)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(storageId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CleanupContentMetaDatabase)
    }

    // nn::Result ActivateContentStorage(nn::ncm::StorageId storageId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ActivateContentStorage, (::nn::ncm::StorageId storageId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ActivateContentStorage)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(storageId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ActivateContentStorage)
    }

    // nn::Result InactivateContentStorage(nn::ncm::StorageId storageId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(InactivateContentStorage, (::nn::ncm::StorageId storageId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(InactivateContentStorage)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(storageId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(InactivateContentStorage)
    }

    // nn::Result ActivateContentMetaDatabase(nn::ncm::StorageId storageId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ActivateContentMetaDatabase, (::nn::ncm::StorageId storageId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ActivateContentMetaDatabase)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(storageId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ActivateContentMetaDatabase)
    }

    // nn::Result InactivateContentMetaDatabase(nn::ncm::StorageId storageId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(InactivateContentMetaDatabase, (::nn::ncm::StorageId storageId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(InactivateContentMetaDatabase)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(storageId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(InactivateContentMetaDatabase)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::ncm::IContentManager>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::ncm::IContentManager))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CreateContentStorage)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CreateContentStorage)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(storageId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CreateContentMetaDatabase)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CreateContentMetaDatabase)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(storageId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(VerifyContentStorage)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(VerifyContentStorage)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(storageId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(VerifyContentMetaDatabase)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(VerifyContentMetaDatabase)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(storageId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(OpenContentStorage)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::ncm::IContentStorage>), outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(OpenContentStorage)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(storageId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outValue, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(OpenContentMetaDatabase)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::ncm::IContentMetaDatabase>), outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(OpenContentMetaDatabase)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(storageId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outValue, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CleanupContentMetaDatabase)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CleanupContentMetaDatabase)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(storageId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ActivateContentStorage)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ActivateContentStorage)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(storageId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(InactivateContentStorage)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(InactivateContentStorage)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(storageId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ActivateContentMetaDatabase)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ActivateContentMetaDatabase)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(storageId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(InactivateContentMetaDatabase)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(InactivateContentMetaDatabase)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(storageId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CreateContentStorage)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CreateContentMetaDatabase)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(VerifyContentStorage)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(VerifyContentMetaDatabase)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(OpenContentStorage)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(OpenContentMetaDatabase)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CleanupContentMetaDatabase)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ActivateContentStorage)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(InactivateContentStorage)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ActivateContentMetaDatabase)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(InactivateContentMetaDatabase)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::ncm::IContentManager))
