﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_ApplicationId.h>
#include <nn/nn_Common.h>
#include <nn/ncm/ncm_DataId.h>
#include <nn/ncm/ncm_ProgramId.h>

namespace nn { namespace ncm {

    struct ApplicationId
    {
        Bit64 value;

        static ApplicationId GetInvalidId() NN_NOEXCEPT
        {
            ApplicationId id = { nn::ApplicationId::GetInvalidId().value };
            return id;
        }

        NN_IMPLICIT operator ProgramId() const
        {
            ProgramId id = { value };
            return id;
        }
    };

    struct ApplicationGroupId
    {
        Bit64 value;
    };

    struct PatchId
    {
        Bit64 value;

        NN_IMPLICIT operator ProgramId() const
        {
            ProgramId id = { value };
            return id;
        }
    };

    struct PatchGroupId
    {
        Bit64 value;
    };

    struct AddOnContentId
    {
        Bit64 value;

        NN_IMPLICIT operator DataId() const
        {
            DataId id = { value };
            return id;
        }
    };

    struct AddOnContentGroupId
    {
        Bit64 id;
    };

    struct DeltaId
    {
        Bit64 value;

        NN_IMPLICIT operator ProgramId() const
        {
            ProgramId id = { value };
            return id;
        }
    };
}}
