﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <array>
#include <functional>
#include <nn/util/util_Optional.h>
#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/nn_SdkAssert.h>
#include <nn/nn_Abort.h>

namespace nn { namespace ncm {

    template <class Key, class T, size_t N>
    class BoundedMap
    {
    public:
        T* Find(const Key& key)
        {
            for(size_t i = 0; i < N; i++)
            {
                if(m_KeyArray[i] && *m_KeyArray[i] == key)
                {
                    return &m_ValueArray[i];
                }
            }

            return nullptr;
        }

        T& operator[] (const Key& key)
        {
            if(auto v = Find(key))
            {
                return *v;
            }

            for(size_t i = 0; i < N; i++)
            {
                if(! m_KeyArray[i])
                {
                    m_KeyArray[i] = key;
                    return m_ValueArray[i];
                }
            }

            NN_ABORT("must not come here");
        }

    private:
        std::array<util::optional<Key>, N> m_KeyArray;
        std::array<T, N> m_ValueArray;
    };

}}
