﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
    @file
    @brief      mbuf モジュール用の、ログを出力する API の宣言です。
*/

#include <nn/nn_Common.h>
#include <nn/diag/detail/diag_DetailStructuredSdkLog.h>

#define NN_DETAIL_MBUF_TRACE(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(mbuf, Trace, 0, ##__VA_ARGS__)
#define NN_DETAIL_MBUF_TRACE_V1(...)                NN_DETAIL_STRUCTURED_SDK_LOG(mbuf, Trace, 1, ##__VA_ARGS__)
#define NN_DETAIL_MBUF_TRACE_V2(...)                NN_DETAIL_STRUCTURED_SDK_LOG(mbuf, Trace, 2, ##__VA_ARGS__)
#define NN_DETAIL_MBUF_TRACE_V3(...)                NN_DETAIL_STRUCTURED_SDK_LOG(mbuf, Trace, 3, ##__VA_ARGS__)

#define NN_DETAIL_MBUF_INFO(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(mbuf, Info, 0, ##__VA_ARGS__)
#define NN_DETAIL_MBUF_INFO_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(mbuf, Info, 1, ##__VA_ARGS__)
#define NN_DETAIL_MBUF_INFO_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(mbuf, Info, 2, ##__VA_ARGS__)
#define NN_DETAIL_MBUF_INFO_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(mbuf, Info, 3, ##__VA_ARGS__)

#define NN_DETAIL_MBUF_WARN(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(mbuf, Warn, 0, ##__VA_ARGS__)
#define NN_DETAIL_MBUF_WARN_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(mbuf, Warn, 1, ##__VA_ARGS__)
#define NN_DETAIL_MBUF_WARN_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(mbuf, Warn, 2, ##__VA_ARGS__)
#define NN_DETAIL_MBUF_WARN_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(mbuf, Warn, 3, ##__VA_ARGS__)

#define NN_DETAIL_MBUF_ERROR(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(mbuf, Error, 0, ##__VA_ARGS__)
#define NN_DETAIL_MBUF_ERROR_V1(...)                NN_DETAIL_STRUCTURED_SDK_LOG(mbuf, Error, 1, ##__VA_ARGS__)
#define NN_DETAIL_MBUF_ERROR_V2(...)                NN_DETAIL_STRUCTURED_SDK_LOG(mbuf, Error, 2, ##__VA_ARGS__)
#define NN_DETAIL_MBUF_ERROR_V3(...)                NN_DETAIL_STRUCTURED_SDK_LOG(mbuf, Error, 3, ##__VA_ARGS__)

#define NN_DETAIL_MBUF_FATAL(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(mbuf, Fatal, 0, ##__VA_ARGS__)
#define NN_DETAIL_MBUF_FATAL_V1(...)                NN_DETAIL_STRUCTURED_SDK_LOG(mbuf, Fatal, 1, ##__VA_ARGS__)
#define NN_DETAIL_MBUF_FATAL_V2(...)                NN_DETAIL_STRUCTURED_SDK_LOG(mbuf, Fatal, 2, ##__VA_ARGS__)
#define NN_DETAIL_MBUF_FATAL_V3(...)                NN_DETAIL_STRUCTURED_SDK_LOG(mbuf, Fatal, 3, ##__VA_ARGS__)

#define NN_DETAIL_MBUF_VTRACE(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(mbuf, Trace, 0, format, args)
#define NN_DETAIL_MBUF_VTRACE_V1(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(mbuf, Trace, 1, format, args)
#define NN_DETAIL_MBUF_VTRACE_V2(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(mbuf, Trace, 2, format, args)
#define NN_DETAIL_MBUF_VTRACE_V3(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(mbuf, Trace, 3, format, args)

#define NN_DETAIL_MBUF_VINFO(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(mbuf, Info, 0, format, args)
#define NN_DETAIL_MBUF_VINFO_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(mbuf, Info, 1, format, args)
#define NN_DETAIL_MBUF_VINFO_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(mbuf, Info, 2, format, args)
#define NN_DETAIL_MBUF_VINFO_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(mbuf, Info, 3, format, args)

#define NN_DETAIL_MBUF_VWARN(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(mbuf, Warn, 0, format, args)
#define NN_DETAIL_MBUF_VWARN_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(mbuf, Warn, 1, format, args)
#define NN_DETAIL_MBUF_VWARN_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(mbuf, Warn, 2, format, args)
#define NN_DETAIL_MBUF_VWARN_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(mbuf, Warn, 3, format, args)

#define NN_DETAIL_MBUF_VERROR(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(mbuf, Error, 0, format, args)
#define NN_DETAIL_MBUF_VERROR_V1(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(mbuf, Error, 1, format, args)
#define NN_DETAIL_MBUF_VERROR_V2(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(mbuf, Error, 2, format, args)
#define NN_DETAIL_MBUF_VERROR_V3(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(mbuf, Error, 3, format, args)

#define NN_DETAIL_MBUF_VFATAL(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(mbuf, Fatal, 0, format, args)
#define NN_DETAIL_MBUF_VFATAL_V1(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(mbuf, Fatal, 1, format, args)
#define NN_DETAIL_MBUF_VFATAL_V2(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(mbuf, Fatal, 2, format, args)
#define NN_DETAIL_MBUF_VFATAL_V3(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(mbuf, Fatal, 3, format, args)

#define NN_DETAIL_MBUF_PUT_TRACE(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(mbuf, Trace, 0, text, length)
#define NN_DETAIL_MBUF_PUT_TRACE_V1(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(mbuf, Trace, 1, text, length)
#define NN_DETAIL_MBUF_PUT_TRACE_V2(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(mbuf, Trace, 2, text, length)
#define NN_DETAIL_MBUF_PUT_TRACE_V3(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(mbuf, Trace, 3, text, length)

#define NN_DETAIL_MBUF_PUT_INFO(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(mbuf, Info, 0, text, length)
#define NN_DETAIL_MBUF_PUT_INFO_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(mbuf, Info, 1, text, length)
#define NN_DETAIL_MBUF_PUT_INFO_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(mbuf, Info, 2, text, length)
#define NN_DETAIL_MBUF_PUT_INFO_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(mbuf, Info, 3, text, length)

#define NN_DETAIL_MBUF_PUT_WARN(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(mbuf, Warn, 0, text, length)
#define NN_DETAIL_MBUF_PUT_WARN_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(mbuf, Warn, 1, text, length)
#define NN_DETAIL_MBUF_PUT_WARN_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(mbuf, Warn, 2, text, length)
#define NN_DETAIL_MBUF_PUT_WARN_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(mbuf, Warn, 3, text, length)

#define NN_DETAIL_MBUF_PUT_ERROR(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(mbuf, Error, 0, text, length)
#define NN_DETAIL_MBUF_PUT_ERROR_V1(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(mbuf, Error, 1, text, length)
#define NN_DETAIL_MBUF_PUT_ERROR_V2(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(mbuf, Error, 2, text, length)
#define NN_DETAIL_MBUF_PUT_ERROR_V3(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(mbuf, Error, 3, text, length)

#define NN_DETAIL_MBUF_PUT_FATAL(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(mbuf, Fatal, 0, text, length)
#define NN_DETAIL_MBUF_PUT_FATAL_V1(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(mbuf, Fatal, 1, text, length)
#define NN_DETAIL_MBUF_PUT_FATAL_V2(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(mbuf, Fatal, 2, text, length)
#define NN_DETAIL_MBUF_PUT_FATAL_V3(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(mbuf, Fatal, 3, text, length)
