﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/ncm/ncm_ProgramId.h>
#include <nn/ncm/ncm_ContentMetaId.h>

#include <nn/lr/lr_LocationResolver.h>
#include <nn/lr/lr_LocationRedirector.h>
#include <nn/lr/lr_RegisteredLocations.h>
#include <nn/lr/lr_IRegisteredLocationResolver.h>


namespace nn { namespace lr {

class RegisteredLocationResolverImpl
{
    NN_DISALLOW_COPY(RegisteredLocationResolverImpl);
    NN_DISALLOW_MOVE(RegisteredLocationResolverImpl);

public:
    RegisteredLocationResolverImpl() NN_NOEXCEPT {}

    Result ResolveProgramPath(sf::Out<lr::Path> outValue, ncm::ProgramId id) NN_NOEXCEPT;
    Result RegisterProgramPath(ncm::ProgramId id, const lr::Path& patchPath) NN_NOEXCEPT;
    Result UnregisterProgramPath(ncm::ProgramId id) NN_NOEXCEPT;
    Result RedirectProgramPath(ncm::ProgramId id, const lr::Path& patchPath) NN_NOEXCEPT;

    Result ResolveHtmlDocumentPath(sf::Out<lr::Path> outValue, ncm::ProgramId id) NN_NOEXCEPT;
    Result RegisterHtmlDocumentPath(ncm::ProgramId id, const lr::Path& patchPath) NN_NOEXCEPT;
    Result UnregisterHtmlDocumentPath(ncm::ProgramId id) NN_NOEXCEPT;
    Result RedirectHtmlDocumentPath(ncm::ProgramId id, const lr::Path& patchPath) NN_NOEXCEPT;

private:
    LocationRedirector m_ProgramRedirector;
    RegisteredLocations<ncm::ProgramId, 1> m_RegisteredPrograms;

    LocationRedirector m_HtmlDocumentRedirector;
    RegisteredLocations<ncm::ProgramId, 1> m_RegisteredHtmlDocuments;
};

}}
