﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <algorithm>

namespace nn { namespace lr {

    struct NN_ALIGNAS(4) Path
    {
        char string[768];
    };

    inline bool IsValid(const Path& path) NN_NOEXCEPT
    {
        return std::any_of(path.string, path.string + NN_ARRAY_SIZE(path.string), [](char c) NN_NOEXCEPT { return c == '\0'; });
    }
}}
