﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Result.h>
#include <nn/ldr/ldr_Types.h>
#include <nn/os/os_Types.h>
#include <nn/svc/svc_Types.h>
#include <nn/ncm/ncm_ProgramId.h>

namespace nn {
namespace ldr {

    namespace detail
    {
        const char PortNameForShell[] = "ldr:shel";
    }

    Result InitializeForShell() NN_NOEXCEPT;
    Result FinalizeForShell() NN_NOEXCEPT;

    Result SetProgramArgument(ncm::ProgramId programId, const void* pArgument, size_t size) NN_NOEXCEPT;
    Result FlushArguments() NN_NOEXCEPT;


} // end of namespace ldr
} // end of namespace nn
