﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Result.h>
#include <nn/ldr/ldr_Types.h>
#include <nn/os/os_Types.h>
#include <nn/svc/svc_Types.h>
#include <nn/ncm/ncm_ProgramLocation.h>

namespace nn {
namespace ldr {

    namespace detail
    {
        const char PortNameForProcessManager[] = "ldr:pm";
    }

    enum CreateProcessFlags
    {
        CreateProcessFlags_EnableException  = (1 << 0),
        CreateProcessFlags_DisableAslr      = (1 << 1)
    };

    Result InitializeForProcessManager() NN_NOEXCEPT;
    Result FinalizeForProcessManager() NN_NOEXCEPT;
    Result CreateProcess(nn::svc::Handle* pOut, PinId id, int flags, nn::svc::Handle resourceLimit) NN_NOEXCEPT;
    Result GetProgramInfo(ProgramInfo* pOut, const ncm::ProgramLocation& location) NN_NOEXCEPT;
    Result PinProgram(PinId* pOutId, const ncm::ProgramLocation& programLocation) NN_NOEXCEPT;
    Result UnpinProgram(PinId id) NN_NOEXCEPT;

} // end of namespace ldr
} // end of namespace nn
