﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// このファイルは SFDL による自動生成ファイルです。
// 手動で変更しないでください。
// This file is auto-generated by the SFDL code generator.
// Do not modify manually.

#include <cstdint>
#include <nn/ldr/ldr_Types.h>
#include <nn/ncm/ncm_ProgramLocation.h>
#include <nn/nn_Result.h>
#include <nn/sf/sf_NativeHandle.h>
#include <nn/sf/cmif/detail/sf_CmifAutogenInterfaceIncludes.h>
#include <nn/sf/detail/sf_AutogenInterfaceIncludes.h>
#include <nn/sf/impl/detail/sf_AutogenImplIncludes.h>

namespace nn { namespace ldr { namespace detail { // NOLINT(whitespace/braces)

class IProcessManagerInterface;

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IProcessManagerInterface, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IProcessManagerInterface)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CreateProcess, (::nn::sf::Out<::nn::sf::NativeHandle> pOut, ::nn::ldr::PinId pinId, ::std::int32_t flags, ::nn::sf::NativeHandle&& resourceLimit))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetProgramInfo, (::nn::sf::Out<::nn::ldr::ProgramInfo> pOut, const ::nn::ncm::ProgramLocation& location))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(PinProgram, (::nn::sf::Out<::nn::ldr::PinId> pOut, const ::nn::ncm::ProgramLocation& programLocation))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(UnpinProgram, (::nn::ldr::PinId pinId))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IProcessManagerInterface)

        ::nn::Result CreateProcess(::nn::sf::Out<::nn::sf::NativeHandle> pOut, ::nn::ldr::PinId pinId, ::std::int32_t flags, ::nn::sf::NativeHandle&& resourceLimit) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CreateProcess, (pOut, pinId, flags, ::std::move(resourceLimit)));
        }

        ::nn::Result GetProgramInfo(::nn::sf::Out<::nn::ldr::ProgramInfo> pOut, const ::nn::ncm::ProgramLocation& location) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetProgramInfo, (pOut, location));
        }

        ::nn::Result PinProgram(::nn::sf::Out<::nn::ldr::PinId> pOut, const ::nn::ncm::ProgramLocation& programLocation) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(PinProgram, (pOut, programLocation));
        }

        ::nn::Result UnpinProgram(::nn::ldr::PinId pinId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(UnpinProgram, (pinId));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IProcessManagerInterface
    {
    public:
        nn::Result CreateProcess(nn::sf::Out<nn::sf::NativeHandle> pOut, nn::ldr::PinId pinId, std::int32_t flags, nn::sf::NativeHandle&& resourceLimit) NN_NOEXCEPT;
        nn::Result GetProgramInfo(nn::sf::Out<nn::ldr::ProgramInfo> pOut, const nn::ncm::ProgramLocation& location) NN_NOEXCEPT;
        nn::Result PinProgram(nn::sf::Out<nn::ldr::PinId> pOut, const nn::ncm::ProgramLocation& programLocation) NN_NOEXCEPT;
        nn::Result UnpinProgram(nn::ldr::PinId pinId) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result CreateProcess(nn::sf::Out<nn::sf::NativeHandle> pOut, nn::ldr::PinId pinId, std::int32_t flags, nn::sf::NativeHandle&& resourceLimit) NN_NOEXCEPT;
    nn::Result GetProgramInfo(nn::sf::Out<nn::ldr::ProgramInfo> pOut, const nn::ncm::ProgramLocation& location) NN_NOEXCEPT;
    nn::Result PinProgram(nn::sf::Out<nn::ldr::PinId> pOut, const nn::ncm::ProgramLocation& programLocation) NN_NOEXCEPT;
    nn::Result UnpinProgram(nn::ldr::PinId pinId) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::ldr::detail::IProcessManagerInterface))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateProcess, (::nn::sf::Out<::nn::sf::NativeHandle> pOut, ::nn::ldr::PinId pinId, ::std::int32_t flags, ::nn::sf::NativeHandle&& resourceLimit))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CreateProcess, (pOut, pinId, flags, ::std::move(resourceLimit)));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetProgramInfo, (::nn::sf::Out<::nn::ldr::ProgramInfo> pOut, const ::nn::ncm::ProgramLocation& location))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetProgramInfo, (pOut, location));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(PinProgram, (::nn::sf::Out<::nn::ldr::PinId> pOut, const ::nn::ncm::ProgramLocation& programLocation))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(PinProgram, (pOut, programLocation));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(UnpinProgram, (::nn::ldr::PinId pinId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(UnpinProgram, (pinId));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::ldr::detail::IProcessManagerInterface>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::ldr::detail::IProcessManagerInterface))

    // nn::Result CreateProcess(nn::sf::Out<nn::sf::NativeHandle> pOut, nn::ldr::PinId pinId, std::int32_t flags, nn::sf::NativeHandle&& resourceLimit) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CreateProcess)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFO(resourceLimit, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFOS_END(1, (resourceLimit))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(pOut, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_MOVE)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (pOut))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(flags, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(pinId, (::nn::ldr::PinId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (flags, pinId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOut), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pinId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(flags), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(resourceLimit)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CreateProcess)

    // nn::Result GetProgramInfo(nn::sf::Out<nn::ldr::ProgramInfo> pOut, const nn::ncm::ProgramLocation& location) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetProgramInfo)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(pOut, 0, (::nn::sf::Out<::nn::ldr::ProgramInfo>), 1024, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pOut))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(location, (::nn::ncm::ProgramLocation), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (location))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOut), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(location)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetProgramInfo)

    // nn::Result PinProgram(nn::sf::Out<nn::ldr::PinId> pOut, const nn::ncm::ProgramLocation& programLocation) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(PinProgram)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(programLocation, (::nn::ncm::ProgramLocation), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (programLocation))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOut, (::nn::ldr::PinId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOut))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOut), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(programLocation)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(PinProgram)

    // nn::Result UnpinProgram(nn::ldr::PinId pinId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(UnpinProgram)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(pinId, (::nn::ldr::PinId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (pinId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pinId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(UnpinProgram)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ldr::PinId), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ldr::ProgramInfo), 1024, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ncm::ProgramLocation), 16, 8)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::ldr::detail::IProcessManagerInterface, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::ldr::detail::IProcessManagerInterface))

    // nn::Result CreateProcess(nn::sf::Out<nn::sf::NativeHandle> pOut, nn::ldr::PinId pinId, std::int32_t flags, nn::sf::NativeHandle&& resourceLimit) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateProcess, (::nn::sf::Out<::nn::sf::NativeHandle> pOut, ::nn::ldr::PinId pinId, ::std::int32_t flags, ::nn::sf::NativeHandle&& resourceLimit))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CreateProcess)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOut)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pinId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(flags)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(resourceLimit)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CreateProcess)
    }

    // nn::Result GetProgramInfo(nn::sf::Out<nn::ldr::ProgramInfo> pOut, const nn::ncm::ProgramLocation& location) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetProgramInfo, (::nn::sf::Out<::nn::ldr::ProgramInfo> pOut, const ::nn::ncm::ProgramLocation& location))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetProgramInfo)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOut)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(location)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetProgramInfo)
    }

    // nn::Result PinProgram(nn::sf::Out<nn::ldr::PinId> pOut, const nn::ncm::ProgramLocation& programLocation) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(PinProgram, (::nn::sf::Out<::nn::ldr::PinId> pOut, const ::nn::ncm::ProgramLocation& programLocation))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(PinProgram)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOut)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(programLocation)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(PinProgram)
    }

    // nn::Result UnpinProgram(nn::ldr::PinId pinId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(UnpinProgram, (::nn::ldr::PinId pinId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(UnpinProgram)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pinId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(UnpinProgram)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::ldr::detail::IProcessManagerInterface>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::ldr::detail::IProcessManagerInterface))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CreateProcess)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLE(resourceLimit)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLES_END
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(pOut)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CreateProcess)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(pOut),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(pinId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(flags),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_NATIVE_HANDLE(resourceLimit)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetProgramInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pOut)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetProgramInfo)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pOut),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(location)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(PinProgram)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(PinProgram)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOut),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(programLocation)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(UnpinProgram)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(UnpinProgram)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(pinId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CreateProcess)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetProgramInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(PinProgram)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(UnpinProgram)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::ldr::detail::IProcessManagerInterface))
