﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>

namespace nn { namespace kvdb {

    class KeyValueArchiveSizeCalculator
    {
    public:
        KeyValueArchiveSizeCalculator() NN_NOEXCEPT;

        void AddEntry(size_t keySize, size_t valueSize) NN_NOEXCEPT;

        size_t GetSize() const NN_NOEXCEPT
        {
            return m_Size;
        }

    private:
        size_t m_Size;
    };

    class KeyValueArchiveBufferWriter
    {
    public:
        KeyValueArchiveBufferWriter(char* buffer, size_t size) NN_NOEXCEPT : m_Buffer(buffer), m_Size(size), m_Position(0){}

        void WriteHeader(uint32_t entryCount) NN_NOEXCEPT;

        void WriteEntry(const void* keyData, size_t keySize, const void* valueData, size_t valueSize) NN_NOEXCEPT;

    private:
        void Write(const void* data, size_t size) NN_NOEXCEPT;

        char* m_Buffer;
        size_t m_Size;
        size_t m_Position;
    };

    class KeyValueArchiveBufferReader
    {
    public:
        KeyValueArchiveBufferReader(const char* buffer, size_t size) : m_Buffer(buffer), m_Size(size), m_Position(0){}

        Result ReadEntryCount(uint32_t* outValue) NN_NOEXCEPT;

        struct KeyValueSize
        {
            size_t keySize;
            size_t valueSize;
        };

        Result GetKeyValueSize(KeyValueSize* outValue) NN_NOEXCEPT;

        Result ReadKeyValue(void* keyData, size_t keySize, void* valueData, size_t valueSize) NN_NOEXCEPT;

    private:
        Result Peak(void* buffer, size_t size) NN_NOEXCEPT;

        Result Read(void* buffer, size_t size) NN_NOEXCEPT;

        const char* m_Buffer;
        size_t m_Size;
        size_t m_Position;
    };
}}
