﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
*   @file
*   @brief  htclow のモジュール内チャネルに関する型定義
*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/htclow/htclow_ModuleTypes.h>

namespace nn { namespace htclow {

/**
*   @brief  チャネル番号を表す型
*   @detail チャネルの番号を表す型です。番号の空間はモジュールごとに独立しています。
*/
typedef uint16_t ChannelId;

/**
*   @brief  チャネル構造体
*/
struct ChannelType
{
    bool _isInitialized;
    ModuleId _moduleId;
    ChannelId _channelId;
};

}}
