﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Allocator.h>
#include <nn/nn_Result.h>
#include <nn/os/os_Types.h>

namespace nn { namespace htc { namespace tenv {

    // Windows 版でない場合、初期化とは別に、利用プロセスの main で nn::fs::SetAllocator(), nn::fs::MountHostRoot() を呼び出してください。
    void Initialize(AllocateFunction alloc, DeallocateFunction dealloc) NN_NOEXCEPT;
    Result RegisterDefinitionFilePath(nn::os::ProcessId processId, const char* path, size_t size) NN_NOEXCEPT;
    void UnregisterDefinitionFilePath(nn::os::ProcessId processId) NN_NOEXCEPT;
    void NotifyMountHostSuccess() NN_NOEXCEPT;
}}}
