﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
    @file
    @brief      htc モジュール用の、ログを出力する API の宣言です。
*/

#include <nn/nn_Common.h>
#include <nn/diag/detail/diag_DetailStructuredSdkLog.h>

#define NN_DETAIL_HTC_TRACE(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(htc, Trace, 0, ##__VA_ARGS__)
#define NN_DETAIL_HTC_TRACE_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(htc, Trace, 1, ##__VA_ARGS__)
#define NN_DETAIL_HTC_TRACE_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(htc, Trace, 2, ##__VA_ARGS__)
#define NN_DETAIL_HTC_TRACE_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(htc, Trace, 3, ##__VA_ARGS__)

#define NN_DETAIL_HTC_INFO(...)                     NN_DETAIL_STRUCTURED_SDK_LOG(htc, Info, 0, ##__VA_ARGS__)
#define NN_DETAIL_HTC_INFO_V1(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(htc, Info, 1, ##__VA_ARGS__)
#define NN_DETAIL_HTC_INFO_V2(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(htc, Info, 2, ##__VA_ARGS__)
#define NN_DETAIL_HTC_INFO_V3(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(htc, Info, 3, ##__VA_ARGS__)

#define NN_DETAIL_HTC_WARN(...)                     NN_DETAIL_STRUCTURED_SDK_LOG(htc, Warn, 0, ##__VA_ARGS__)
#define NN_DETAIL_HTC_WARN_V1(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(htc, Warn, 1, ##__VA_ARGS__)
#define NN_DETAIL_HTC_WARN_V2(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(htc, Warn, 2, ##__VA_ARGS__)
#define NN_DETAIL_HTC_WARN_V3(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(htc, Warn, 3, ##__VA_ARGS__)

#define NN_DETAIL_HTC_ERROR(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(htc, Error, 0, ##__VA_ARGS__)
#define NN_DETAIL_HTC_ERROR_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(htc, Error, 1, ##__VA_ARGS__)
#define NN_DETAIL_HTC_ERROR_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(htc, Error, 2, ##__VA_ARGS__)
#define NN_DETAIL_HTC_ERROR_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(htc, Error, 3, ##__VA_ARGS__)

#define NN_DETAIL_HTC_FATAL(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(htc, Fatal, 0, ##__VA_ARGS__)
#define NN_DETAIL_HTC_FATAL_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(htc, Fatal, 1, ##__VA_ARGS__)
#define NN_DETAIL_HTC_FATAL_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(htc, Fatal, 2, ##__VA_ARGS__)
#define NN_DETAIL_HTC_FATAL_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(htc, Fatal, 3, ##__VA_ARGS__)

#define NN_DETAIL_HTC_VTRACE(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(htc, Trace, 0, format, args)
#define NN_DETAIL_HTC_VTRACE_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(htc, Trace, 1, format, args)
#define NN_DETAIL_HTC_VTRACE_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(htc, Trace, 2, format, args)
#define NN_DETAIL_HTC_VTRACE_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(htc, Trace, 3, format, args)

#define NN_DETAIL_HTC_VINFO(format, args)           NN_DETAIL_STRUCTURED_SDK_VLOG(htc, Info, 0, format, args)
#define NN_DETAIL_HTC_VINFO_V1(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(htc, Info, 1, format, args)
#define NN_DETAIL_HTC_VINFO_V2(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(htc, Info, 2, format, args)
#define NN_DETAIL_HTC_VINFO_V3(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(htc, Info, 3, format, args)

#define NN_DETAIL_HTC_VWARN(format, args)           NN_DETAIL_STRUCTURED_SDK_VLOG(htc, Warn, 0, format, args)
#define NN_DETAIL_HTC_VWARN_V1(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(htc, Warn, 1, format, args)
#define NN_DETAIL_HTC_VWARN_V2(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(htc, Warn, 2, format, args)
#define NN_DETAIL_HTC_VWARN_V3(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(htc, Warn, 3, format, args)

#define NN_DETAIL_HTC_VERROR(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(htc, Error, 0, format, args)
#define NN_DETAIL_HTC_VERROR_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(htc, Error, 1, format, args)
#define NN_DETAIL_HTC_VERROR_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(htc, Error, 2, format, args)
#define NN_DETAIL_HTC_VERROR_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(htc, Error, 3, format, args)

#define NN_DETAIL_HTC_VFATAL(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(htc, Fatal, 0, format, args)
#define NN_DETAIL_HTC_VFATAL_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(htc, Fatal, 1, format, args)
#define NN_DETAIL_HTC_VFATAL_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(htc, Fatal, 2, format, args)
#define NN_DETAIL_HTC_VFATAL_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(htc, Fatal, 3, format, args)

#define NN_DETAIL_HTC_PUT_TRACE(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(htc, Trace, 0, text, length)
#define NN_DETAIL_HTC_PUT_TRACE_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(htc, Trace, 1, text, length)
#define NN_DETAIL_HTC_PUT_TRACE_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(htc, Trace, 2, text, length)
#define NN_DETAIL_HTC_PUT_TRACE_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(htc, Trace, 3, text, length)

#define NN_DETAIL_HTC_PUT_INFO(text, length)        NN_DETAIL_STRUCTURED_SDK_PUT(htc, Info, 0, text, length)
#define NN_DETAIL_HTC_PUT_INFO_V1(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(htc, Info, 1, text, length)
#define NN_DETAIL_HTC_PUT_INFO_V2(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(htc, Info, 2, text, length)
#define NN_DETAIL_HTC_PUT_INFO_V3(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(htc, Info, 3, text, length)

#define NN_DETAIL_HTC_PUT_WARN(text, length)        NN_DETAIL_STRUCTURED_SDK_PUT(htc, Warn, 0, text, length)
#define NN_DETAIL_HTC_PUT_WARN_V1(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(htc, Warn, 1, text, length)
#define NN_DETAIL_HTC_PUT_WARN_V2(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(htc, Warn, 2, text, length)
#define NN_DETAIL_HTC_PUT_WARN_V3(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(htc, Warn, 3, text, length)

#define NN_DETAIL_HTC_PUT_ERROR(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(htc, Error, 0, text, length)
#define NN_DETAIL_HTC_PUT_ERROR_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(htc, Error, 1, text, length)
#define NN_DETAIL_HTC_PUT_ERROR_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(htc, Error, 2, text, length)
#define NN_DETAIL_HTC_PUT_ERROR_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(htc, Error, 3, text, length)

#define NN_DETAIL_HTC_PUT_FATAL(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(htc, Fatal, 0, text, length)
#define NN_DETAIL_HTC_PUT_FATAL_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(htc, Fatal, 1, text, length)
#define NN_DETAIL_HTC_PUT_FATAL_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(htc, Fatal, 2, text, length)
#define NN_DETAIL_HTC_PUT_FATAL_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(htc, Fatal, 3, text, length)
