﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/fssystem/fs_IndirectStorage.h>
#include <nn/fssystem/fs_AesCtrCounterExtendedStorage.h>

namespace nn { namespace fssystem { namespace utilTool {

/**
 * @brief   IndirectStorage の検証クラスです。
 */
class IndirectStorageChecker
{
public:
    // ストレージの整合性を検証します。
    static Result Verify(IndirectStorage* pStorage) NN_NOEXCEPT;
};

/**
 * @brief   AesCtrCounterExtendedStorage の検証クラスです。
 */
class AesCtrCounterExtendedStorageChecker
{
public:
    // 検証するストレージの範囲
    struct Range
    {
        int64_t offset;
        int64_t size;

        void Reset() NN_NOEXCEPT
        {
            this->offset = 0;
            this->size = 0;
        }

        bool IsEmpty() const NN_NOEXCEPT
        {
            return this->size == 0;
        }
    };
    NN_STATIC_ASSERT(std::is_pod<Range>::value);

    // ストレージの情報
    // TODO: 可能であれば pDataStorage と pCheckStorage を統合する
    struct StorageInfo
    {
        int64_t dataOffset;
        fs::IStorage* pDataStorage;
        AesCtrCounterExtendedStorage* pCheckStorage;
        uint32_t generation;
    };
    NN_STATIC_ASSERT(std::is_pod<StorageInfo>::value);

public:
    // ストレージの整合性を検証します。
    static Result Verify(
        AesCtrCounterExtendedStorage* pStorage, uint32_t generation) NN_NOEXCEPT;

    // コンストラクタです。
    AesCtrCounterExtendedStorageChecker() NN_NOEXCEPT;

    // 2 パッチ間のストレージの整合性を検証します。
    Result Verify(const StorageInfo& previous, const StorageInfo& current) NN_NOEXCEPT;

    // Verify() で失敗した範囲。
    const Range& GetResultRange() const NN_NOEXCEPT
    {
        return m_ResultRange;
    }

private:
    typedef AesCtrCounterExtendedStorage::Entry Entry;

private:
    // 指定範囲の整合性を検証します。
    Result CheckRange(
               const StorageInfo& previous,
               const StorageInfo& current,
               Range range,
               uint32_t generation
           ) NN_NOEXCEPT;

private:
    Range m_ResultRange;
    std::unique_ptr<char[]> m_Buffer1;
    std::unique_ptr<char[]> m_Buffer2;
};

}}}
