﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/os/os_Mutex.h>

namespace nn { namespace fs {

class IStorage;

}}

namespace nn { namespace fssystem { namespace save {

// セーブデータ内部ストレージアクセス用の Visitor
class IInternalStorageFileSystemVisitor
{
public:
    virtual ~IInternalStorageFileSystemVisitor() NN_NOEXCEPT {}

public:
    virtual Result VisitStorage(const char* name, fs::IStorage* pStorage) NN_NOEXCEPT = 0;
};

// セーブデータ内部ストレージアクセス可能なファイルシステムを示すインターフェースクラス
class IInternalStorageFileSystem
{
public:
    virtual ~IInternalStorageFileSystem() NN_NOEXCEPT {}

public:
    virtual Result AcceptVisitor(IInternalStorageFileSystemVisitor* pVisitor) NN_NOEXCEPT = 0;

    virtual Result Commit() NN_NOEXCEPT = 0;

    virtual Result CommitProvisionally(int64_t counter) NN_NOEXCEPT = 0;

    virtual Result Rollback() NN_NOEXCEPT = 0;
};

}}}
