﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/fs/fs_SaveDataTypes.h>
#include <nn/fssystem/fs_ApplicationTemporaryFileSystem.h>
#include <nn/fssystem/fs_SaveDataFileSystem.h>

namespace nn { namespace fssystem {

class ISaveDataFileSystemCacheManager
{
public:
    virtual ~ISaveDataFileSystemCacheManager() NN_NOEXCEPT
    {
    }
    virtual bool GetCache(std::shared_ptr<nn::fssystem::SaveDataFileSystem>* pOut, nn::fs::SaveDataSpaceId saveDataSpaceId, nn::fs::SaveDataId id) NN_NOEXCEPT = 0;
    virtual void Register(std::shared_ptr<nn::fssystem::SaveDataFileSystem>&& pFileSystem) NN_NOEXCEPT = 0;
    virtual void Register(std::shared_ptr<nn::fssystem::ApplicationTemporaryFileSystem>&& pFileSystem) NN_NOEXCEPT = 0;
    virtual void Unregister(nn::fs::SaveDataSpaceId saveDataSpaceId, nn::fs::SaveDataId id) NN_NOEXCEPT = 0;
};

}}
