﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/fs/fs_SaveDataTypes.h>

namespace nn { namespace fs {
    class IStorage;
}}

namespace nn { namespace fssystem {

    class ISaveDataExtraDataAccessor;

    class ISaveDataExtraDataAccessorCacheObserver
    {
    public:
        virtual ~ISaveDataExtraDataAccessorCacheObserver() {}
        virtual void Unregister(nn::fs::SaveDataSpaceId spaceId, nn::fs::SaveDataId saveDataId, nn::fssystem::ISaveDataExtraDataAccessor* accessor) NN_NOEXCEPT = 0;
    };

    class ISaveDataExtraDataAccessor
    {
    public:
        virtual ~ISaveDataExtraDataAccessor() NN_NOEXCEPT {}
        virtual Result WriteExtraData(const nn::fs::SaveDataExtraData& extraData) NN_NOEXCEPT = 0;
        virtual Result CommitExtraData(bool updateTimeStampAndHash) NN_NOEXCEPT = 0;
        virtual Result ReadExtraData(nn::fs::SaveDataExtraData* outValue) NN_NOEXCEPT = 0;
        virtual void RegisterCacheObserver(ISaveDataExtraDataAccessorCacheObserver* observer, nn::fs::SaveDataSpaceId spaceId, nn::fs::SaveDataId saveDataId) NN_NOEXCEPT = 0;
    };

}}
