﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>

#include <nn/fs/fs_IStorage.h>
#include <nn/fs/fs_SaveDataTypes.h>
#include <nn/fs/fsa/fs_IFileSystem.h>
#include <nn/fs/detail/fs_Newable.h>
#include <nn/fssystem/fs_ISaveDataExtraDataAccessor.h>
#include <nn/fssystem/save/fs_IntegritySaveDataFileSystemDriver.h>

namespace nn { namespace fssystem {

    namespace save {
        struct IntegritySaveDataParameters;
    }

    class ApplicationTemporaryFileSystem : public nn::fs::fsa::IFileSystem, public nn::fs::detail::Newable, public ISaveDataExtraDataAccessor
    {
    public:
        ApplicationTemporaryFileSystem() NN_NOEXCEPT;

        Result Initialize(nn::fs::IStorage* pStorage, IBufferManager* pBufferManager, IMacGenerator* pMacGenerator) NN_NOEXCEPT;
        Result Initialize(std::shared_ptr<nn::fs::IStorage> pStorage, IBufferManager* pBufferManager, IMacGenerator* pMacGenerator) NN_NOEXCEPT;
        virtual ~ApplicationTemporaryFileSystem() NN_NOEXCEPT;

        virtual Result DoCreateFile(const char *path, int64_t size, int option) NN_NOEXCEPT NN_OVERRIDE;
        virtual Result DoDeleteFile(const char *path) NN_NOEXCEPT NN_OVERRIDE;
        virtual Result DoCreateDirectory(const char *path) NN_NOEXCEPT NN_OVERRIDE;
        virtual Result DoDeleteDirectory(const char *path) NN_NOEXCEPT NN_OVERRIDE;
        virtual Result DoDeleteDirectoryRecursively(const char *path) NN_NOEXCEPT NN_OVERRIDE;
        virtual Result DoCleanDirectoryRecursively(const char* path) NN_NOEXCEPT NN_OVERRIDE;
        virtual Result DoRenameFile(const char *currentPath, const char *newPath) NN_NOEXCEPT NN_OVERRIDE;
        virtual Result DoRenameDirectory(const char *currentPath, const char *newPath) NN_NOEXCEPT NN_OVERRIDE;
        virtual Result DoGetEntryType(nn::fs::DirectoryEntryType* outValue, const char *path) NN_NOEXCEPT NN_OVERRIDE;
        virtual Result DoOpenFile(std::unique_ptr<nn::fs::fsa::IFile>* outValue, const char* path, nn::fs::OpenMode mode) NN_NOEXCEPT NN_OVERRIDE;
        virtual Result DoOpenDirectory(std::unique_ptr<nn::fs::fsa::IDirectory>* outValue, const char* path, nn::fs::OpenDirectoryMode mode) NN_NOEXCEPT NN_OVERRIDE;
        virtual Result DoCommit() NN_NOEXCEPT NN_OVERRIDE;
        virtual Result DoCommitProvisionally(int64_t counter) NN_NOEXCEPT NN_OVERRIDE;
        virtual Result DoRollback() NN_NOEXCEPT NN_OVERRIDE;
        virtual Result DoGetFreeSpaceSize(int64_t* outValue, const char *path) NN_NOEXCEPT NN_OVERRIDE;
        virtual Result DoGetTotalSpaceSize(int64_t* outValue, const char *path) NN_NOEXCEPT NN_OVERRIDE;

    public:
        virtual Result WriteExtraData(const nn::fs::SaveDataExtraData& extraData) NN_NOEXCEPT NN_OVERRIDE;
        virtual Result CommitExtraData(bool updateTimeStampAndHash) NN_NOEXCEPT  NN_OVERRIDE;
        virtual Result ReadExtraData(nn::fs::SaveDataExtraData* outValue) NN_NOEXCEPT NN_OVERRIDE;
        virtual void RegisterCacheObserver(ISaveDataExtraDataAccessorCacheObserver* observer, nn::fs::SaveDataSpaceId spaceId, nn::fs::SaveDataId saveDataId) NN_NOEXCEPT NN_OVERRIDE;

    private:
        std::shared_ptr<nn::fs::IStorage> m_Storage;
        nn::fssystem::save::IntegritySaveDataFileSystemDriver m_FileSystem;

        ISaveDataExtraDataAccessorCacheObserver* m_Observer;
        nn::fs::SaveDataId m_SaveDataId;
        nn::fs::SaveDataSpaceId m_SpaceId;
    };

}}
