﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <type_traits>

#include <nn/nn_BitTypes.h>
#include <nn/nn_StaticAssert.h>

#include <nn/fs/fs_Types.h>

namespace nn { namespace fssystem { namespace dbm {
namespace
{
    // ファイル、ディレクトリエントリの付加情報として使用可能なサイズ
    // ディレクトリエントリは 96 バイトのうち、84 バイトが使われている
    const size_t DirectoryInfoSize = 12;
    // ファイルエントリは 96 バイトのうち、88 バイトが使われている
    const size_t FileInfoSize = 8;
}

//! パス長
static const size_t MaxDirectoryNameLength = 64;
static const size_t MaxFileNameLength = 64;
static const size_t MaxIdLength = 8;

//! パス用文字列型
typedef char PathChar;

//! ディレクトリ名
struct DirectoryName
{
    PathChar name[MaxDirectoryNameLength];
};
NN_STATIC_ASSERT(std::is_pod<DirectoryName>::value);

//! ファイル名
struct FileName
{
    PathChar name[MaxFileNameLength];
};
NN_STATIC_ASSERT(std::is_pod<FileName>::value);

//! ファイル情報
struct FileOptionalInfo
{
    Bit8 info[FileInfoSize];
};
NN_STATIC_ASSERT(std::is_pod<FileOptionalInfo>::value);

namespace detail
{
    //! ディレクトリ付加情報
    struct DirectoryInfo
    {
        Bit8 info[DirectoryInfoSize];
    };
    NN_STATIC_ASSERT(std::is_pod<DirectoryInfo>::value);

    //! ファイル情報
    struct FileSystemInfo
    {
        uint32_t index;         //! Allocation Table での先頭インデックス
        fs::Int64 size;
    };
    NN_STATIC_ASSERT(std::is_pod<FileSystemInfo>::value);

    //! ファイル付加情報
    struct FileInfo
    {
        FileSystemInfo  fs;
        FileOptionalInfo  fo;
    };
    NN_STATIC_ASSERT(std::is_pod<FileInfo>::value);
}

}}}
