﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <memory>
#include <mutex>
#include <nn/nn_Common.h>
#include <nn/fssrv/fssrv_SaveDataIndexer.h>
#include <nn/fs/fs_SaveDataTypes.h>
#include <nn/util/util_Optional.h>

namespace nn { namespace fssrv {

    const nn::fs::StaticSaveDataId IndexerSaveDataId = 0x8000000000000000;

    typedef uint32_t DeviceHandle;
    class IDeviceHandleManager
    {
    public:
        virtual Result GetHandle(DeviceHandle* pOutValue) = 0;
        virtual bool IsValid(DeviceHandle handle) = 0;
    };

    void InitializeSaveDataIndexerManager(fs::SaveDataId indexerSaveDataId, MemoryResource* pMemoryResource, IDeviceHandleManager* pSdHandleManager, bool enableBisUserRedirection) NN_NOEXCEPT;
    void InvalidateSdCardSaveDataIndexer() NN_NOEXCEPT;
    void ResetTemporaryStorageIndexer() NN_NOEXCEPT;

    // SaveDataIndexer のインターフェイスを取得します。
    // コンストラクタでロックを取得し、デストラクタで解放します。
    class SaveDataIndexerAccessor
    {
    public:
        SaveDataIndexerAccessor() NN_NOEXCEPT
            : m_pIndexer(nullptr)
        {
        }
        ~SaveDataIndexerAccessor() NN_NOEXCEPT;
        nn::Result Initialize(fs::SaveDataSpaceId spaceId) NN_NOEXCEPT;
        ISaveDataIndexer* GetInterface() NN_NOEXCEPT;

    private:
        std::unique_lock<os::Mutex> m_Mutex;
        ISaveDataIndexer*           m_pIndexer;
    };

}}
