﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Allocator.h>

namespace nn { namespace mem {
    class StandardAllocator;
}}

namespace nn { namespace fssrv {

    /**
       @brief nn::mem::StandardAllocator を使用する nn::MemoryResource の実装です。
       @details コンストラクタに初期化済みのアロケータを指定する必要があります。
    */
    class MemoryResourceFromStandardAllocator : public nn::MemoryResource
    {
    public:
        explicit MemoryResourceFromStandardAllocator(nn::mem::StandardAllocator* pAllocator) NN_NOEXCEPT;
    public:
        size_t GetFreeSizePeak() const NN_NOEXCEPT
        {
            return m_SizeFreePeak;
        }
        void ClearPeak() NN_NOEXCEPT;
    protected:
        virtual void* do_allocate(std::size_t bytes, std::size_t alignment) NN_NOEXCEPT NN_OVERRIDE;
        virtual void do_deallocate(void* p, std::size_t bytes, std::size_t alignment) NN_NOEXCEPT NN_OVERRIDE;
        virtual bool do_is_equal(const nn::MemoryResource& other) const NN_NOEXCEPT NN_OVERRIDE
        {
            NN_UNUSED(other);
            return false;
        }
    private:
        nn::mem::StandardAllocator* m_Allocator;
        size_t m_SizeFreePeak;
        size_t m_SizeFreeInitial;
    };

}}
