﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

namespace nn { namespace fssrv { namespace fscreator {
    struct FileSystemCreatorInterfaces;
}}}

namespace nn { namespace fssystem {
    class IBufferManager;
}}

namespace nn { namespace fssrv {

    using GenerateRandomFunction = void(*)(void*, size_t);

    struct SaveDataTransferCryptoConfiguration;

    struct InternalProgramIdRangeForSpeedEmulation
    {
        nn::Bit64 programIdValueMin;
        nn::Bit64 programIdValueMax;
    };

    void InitializeLocationResolverSet() NN_NOEXCEPT;
    void WaitSettingsAndPresetGcInternalKeys() NN_NOEXCEPT;

    // TODO: FileSystemProxyCoreImpl をクラス分離する際にコンストラクタに移動
    // fileSystemCreatorInterfaces, pBufferManager, pSaveDataTransferCryptoConfiguration は fsp を使用する間生存している必要がある
    void InitializeFileSystemProxy(fscreator::FileSystemCreatorInterfaces* pFileSystemCreatorInterfaces, fssystem::IBufferManager* pBufferManager, bool isDebugFunctionEnabled, SaveDataTransferCryptoConfiguration* pSaveDataTransferCryptoConfiguration, InternalProgramIdRangeForSpeedEmulation* pInternalProgramIdRangeForSpeedEmulation, GenerateRandomFunction generateRandom) NN_NOEXCEPT;

    void NotifyProcessDeferred(nn::Bit64 processId) NN_NOEXCEPT;

    // TODO: 以下の関数は fs_Main 内に移動する
    void InitializeFileSystemProxyServer(int countThreads) NN_NOEXCEPT;
    void LoopFileSystemProxyServer() NN_NOEXCEPT;
    void LoopPmEventServer(void(*pCallbackOnWake)()) NN_NOEXCEPT; // TODO: もっと汎用的な I/F にする

}}
