﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/fssrv/fssrv_IFileSystemCreator.h>
#include <nn/fssystem/buffers/fs_IBufferManager.h>

namespace nn {
    class MemoryResource;

namespace fssystem {
    struct NcaCryptoConfiguration;
}
}


namespace nn { namespace fssrv { namespace fscreator {

    class StorageOnNcaCreator : public IStorageOnNcaCreator
    {
        NN_DISALLOW_COPY(StorageOnNcaCreator);
        NN_DISALLOW_MOVE(StorageOnNcaCreator);
    public:
        //! pAllocator, cryptoConfig は破棄されるまで参照される
        explicit StorageOnNcaCreator(nn::MemoryResource* pAllocator, const fssystem::NcaCryptoConfiguration& cryptoConfig, bool isProd, nn::fssystem::IBufferManager* pBufferManager) NN_NOEXCEPT;
        virtual Result Create(std::shared_ptr<fs::IStorage>* outValue, fssystem::NcaFsHeaderReader* outFsHeaderReader, std::shared_ptr<fssystem::NcaReader> ncaReader, int index, bool verifyHeaderSign2) NN_NOEXCEPT NN_OVERRIDE;
        virtual Result CreateWithPatch(std::shared_ptr<fs::IStorage>* outValue, fssystem::NcaFsHeaderReader* outFsHeaderReader, std::shared_ptr<fssystem::NcaReader> originalNcaReader, std::shared_ptr<fssystem::NcaReader> currentNcaReader, int index, bool verifyHeaderSign2) NN_NOEXCEPT NN_OVERRIDE;
        virtual Result CreateNcaReader(std::shared_ptr<fssystem::NcaReader>* outValue, std::shared_ptr<fs::IStorage> storage) NN_NOEXCEPT NN_OVERRIDE;
        virtual Result VerifyAcid(fs::fsa::IFileSystem* pFileSystem, fssystem::NcaReader* ncaReader) NN_NOEXCEPT NN_OVERRIDE;

    private:
        Result VerifyNcaHeaderSign2(fssystem::NcaReader* ncaReader, fs::IStorage* storage) NN_NOEXCEPT;
        nn::MemoryResource* m_Allocator;
        const fssystem::NcaCryptoConfiguration& m_CryptoConfig;
        bool m_IsProd;
        nn::fssystem::IBufferManager* const m_pBufferManager;
    };

}}}
