﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/fssrv/fssrv_IFileSystemCreator.h>
#include <nn/nn_Allocator.h>
#include <nn/os/os_Mutex.h>
#include <nn/fs/fs_ErrorInfoPrivate.h>


namespace nn {

namespace fssystem
{
    class ProxyFileSystem;
}

namespace fssrv { namespace fscreator {

    class SdCardProxyFileSystemCreatorHostFs : public ISdCardProxyFileSystemCreator
    {
        NN_DISALLOW_COPY(SdCardProxyFileSystemCreatorHostFs);
        NN_DISALLOW_MOVE(SdCardProxyFileSystemCreatorHostFs);
    private:
        Result OpenSdCardFileSystem(std::shared_ptr<nn::fs::fsa::IFileSystem>* pOutFileSystem, bool isUncache) NN_NOEXCEPT;

    public:
        SdCardProxyFileSystemCreatorHostFs(
            IHostFileSystemCreator* pHostFsCreator
        ) NN_NOEXCEPT
            : m_pHostFsCreator(pHostFsCreator)
        {
        }

    public:
        virtual Result Create(std::shared_ptr<fs::fsa::IFileSystem>* pOutFileSystem) NN_NOEXCEPT NN_OVERRIDE;
        virtual Result Format(bool isUncache) NN_NOEXCEPT NN_OVERRIDE;
        virtual Result Format() NN_NOEXCEPT NN_OVERRIDE;
        virtual void Initialize(fs::FileSystemProxyErrorInfo* pErrorInfo, os::Mutex* pErrorInfoMutex) NN_NOEXCEPT NN_OVERRIDE;

    private:

        IHostFileSystemCreator* const m_pHostFsCreator;
    };

}}}
