﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/fssrv/fssrv_IFileSystemCreator.h>
#include <nn/fat/fat_FatFileSystem.h>

namespace nn {
    class MemoryResource;
}

namespace nn { namespace fssrv { namespace fscreator {

    class FatFileSystemCreator : public IFatFileSystemCreator
    {
        NN_DISALLOW_COPY(FatFileSystemCreator);
        NN_DISALLOW_MOVE(FatFileSystemCreator);
    public:
        explicit FatFileSystemCreator(nn::MemoryResource* pAllocator) NN_NOEXCEPT;
        virtual Result Create(std::shared_ptr<nn::fs::fsa::IFileSystem>* outValue, std::shared_ptr<fs::IStorage> storage, nn::fat::FatAttribute* pFatAttribute, std::unique_ptr<nn::fat::FatErrorInfoSetter>&& pFatErrorInfoSetter, nn::Result resultInvalidFatFormat, nn::Result resultUsableSpaceNotEnough) NN_NOEXCEPT NN_OVERRIDE;
        virtual Result Format(std::shared_ptr<fs::IStorage> storage, nn::fat::FatAttribute* pFatAttribute, nn::fat::FatFormatParam* pFatFormatParam, std::unique_ptr<nn::fat::FatErrorInfoSetter>&& pFatErrorInfoSetter, nn::Result resultInvalidFatFormat, nn::Result resultUsableSpaceNotEnough) NN_NOEXCEPT NN_OVERRIDE;
    private:
        nn::MemoryResource* m_Allocator;
    };
}}}
