﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <memory>
#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/fs/fs_FileSystem.h>
#include <nn/fs/fs_SaveDataTypes.h>
#include <nn/sf/sf_ISharedObject.h>

namespace nn {

namespace fs { namespace fsa {
    class IFile;
    class IFileSystem;
}}

namespace fssrv { namespace detail {

    class ISaveDataTransferCoreInterface : public nn::sf::ISharedObject
    {
    public:
        virtual ~ISaveDataTransferCoreInterface() NN_NOEXCEPT {}

        virtual Result GetFreeSpaceSizeForSaveData(nn::sf::Out<std::int64_t> outValue, std::uint8_t saveDataSpaceId) NN_NOEXCEPT = 0;
        virtual Result QuerySaveDataTotalSize(nn::sf::Out<int64_t> outValue, std::int64_t saveDataSize, std::int64_t saveDataJournalSize) NN_NOEXCEPT = 0;

        virtual Result CheckSaveDataFile(nn::fs::SaveDataId saveDataId, nn::fs::SaveDataSpaceId saveDataSpaceId) NN_NOEXCEPT = 0;
        virtual Result CreateSaveDataFileSystemCore(const nn::fs::SaveDataAttribute& attribute, const nn::fs::SaveDataCreationInfo& creationInfo, const nn::fs::SaveDataMetaInfo& metaInfo, const nn::fs::SaveDataHashSalt& hashSalt, bool isImportable) NN_NOEXCEPT = 0;
        virtual Result GetSaveDataInfo(nn::fs::SaveDataInfo* outValue, nn::fs::SaveDataSpaceId saveDataSpaceId, nn::fs::SaveDataAttribute saveDataAttribute) NN_NOEXCEPT = 0;
        virtual Result ReadSaveDataFileSystemExtraDataCore(nn::fs::SaveDataExtraData* outValue, nn::fs::SaveDataSpaceId saveDataSpaceId, nn::fs::SaveDataId saveDataId, bool isTemporaryFs) NN_NOEXCEPT = 0;
        virtual Result WriteSaveDataFileSystemExtraDataCore(nn::fs::SaveDataSpaceId saveDataSpaceId, nn::fs::SaveDataId saveDataId, const nn::fs::SaveDataExtraData& extraData, nn::fs::SaveDataType saveDataType, bool updateTimeStampAndHash) NN_NOEXCEPT = 0;
        virtual Result FinalizeSaveDataCreation(nn::fs::SaveDataId saveDataId, nn::fs::SaveDataSpaceId saveDataSpaceId) NN_NOEXCEPT = 0;
        virtual Result CancelSaveDataCreation(nn::fs::SaveDataId saveDataId, nn::fs::SaveDataSpaceId saveDataSpaceId) NN_NOEXCEPT = 0;
        virtual Result OpenSaveDataFile(std::shared_ptr<fs::fsa::IFile>* outValue, nn::fs::SaveDataSpaceId saveDataSpaceId, nn::fs::SaveDataId saveDataId, nn::fs::OpenMode mode) NN_NOEXCEPT = 0;
        virtual Result OpenSaveDataMetaFileRaw(std::shared_ptr<fs::fsa::IFile>* outValue, nn::fs::SaveDataSpaceId spaceId, nn::fs::SaveDataId saveDataId, fs::SaveDataMetaType metaType, nn::fs::OpenMode mode) NN_NOEXCEPT = 0;
        virtual Result OpenSaveDataInternalStorageFileSystemCore(std::shared_ptr<nn::fs::fsa::IFileSystem>* outValue, nn::fs::SaveDataSpaceId saveDataSpaceId, nn::fs::SaveDataId saveDataId) NN_NOEXCEPT = 0;
        virtual Result ExtendSaveDataFileSystem(std::uint8_t spaceId, nn::fs::SaveDataId saveDataId, int64_t saveDataAvailableSize, int64_t saveDataJournalSize) NN_NOEXCEPT = 0;
        virtual Result DeleteSaveDataFileSystemBySaveDataSpaceId(std::uint8_t spaceId, nn::fs::SaveDataId saveDataId) NN_NOEXCEPT = 0;
        virtual Result SwapSaveDataKeyAndState(std::uint8_t spaceId, nn::fs::SaveDataId lhsSaveDataId, nn::fs::SaveDataId rhsSaveDataId) NN_NOEXCEPT = 0;

    };

}}
}
